/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.chef.suppliers;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.logging.Logger;
import org.jclouds.rest.annotations.ApiVersion;

@Singleton
public class ChefVersionSupplier
implements Supplier<Integer> {
    public static final Integer FALLBACK_VERSION = 10;
    @Resource
    @Named(value="jclouds.chef")
    private Logger logger = Logger.NULL;
    private final String apiVersion;

    @Inject
    ChefVersionSupplier(@ApiVersion String apiVersion) {
        this.apiVersion = Preconditions.checkNotNull(apiVersion, "apiVersion must not be null");
    }

    @Override
    public Integer get() {
        Pattern versionPattern = Pattern.compile("(?:0\\.(\\d+)|(\\d+)\\.\\d+)(?:\\.\\d)*");
        Matcher m = versionPattern.matcher(this.apiVersion);
        if (!m.matches()) {
            this.logger.warn("Configured version does not match the standard version pattern. Assuming version %s", FALLBACK_VERSION);
            return FALLBACK_VERSION;
        }
        return Integer.valueOf(MoreObjects.firstNonNull(m.group(1), m.group(2)));
    }
}

