/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.s3.blobstore;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import org.jclouds.aws.s3.AWSS3Client;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.functions.BlobToHttpGetOptions;
import org.jclouds.blobstore.util.BlobStoreUtils;
import org.jclouds.http.HttpRequest;
import org.jclouds.reflect.Invocation;
import org.jclouds.rest.internal.RestAnnotationProcessor;
import org.jclouds.s3.blobstore.S3BlobRequestSigner;
import org.jclouds.s3.blobstore.functions.BlobToObject;
import org.jclouds.s3.filters.RequestAuthorizeSignature;

public class AWSS3BlobRequestSignerV4
extends S3BlobRequestSigner<AWSS3Client> {
    private final RequestAuthorizeSignature authSigner;

    @Inject
    public AWSS3BlobRequestSignerV4(RestAnnotationProcessor processor, BlobToObject blobToObject, BlobToHttpGetOptions blob2HttpGetOptions, Class<AWSS3Client> interfaceClass, RequestAuthorizeSignature authSigner) throws SecurityException, NoSuchMethodException {
        super(processor, blobToObject, blob2HttpGetOptions, interfaceClass, authSigner);
        this.authSigner = authSigner;
    }

    @Override
    public HttpRequest signGetBlob(String container, String name, long timeInSeconds) {
        Preconditions.checkNotNull(container, "container");
        Preconditions.checkNotNull(name, "name");
        HttpRequest request = this.processor.apply(Invocation.create(this.getMethod, ImmutableList.of(container, name)));
        request = this.authSigner.signForTemporaryAccess(request, timeInSeconds);
        return BlobStoreUtils.cleanRequest(request);
    }

    @Override
    public HttpRequest signPutBlob(String container, Blob blob, long timeInSeconds) {
        Preconditions.checkNotNull(container, "container");
        Preconditions.checkNotNull(blob, "blob");
        HttpRequest request = this.processor.apply(Invocation.create(this.createMethod, ImmutableList.of(container, this.blobToObject.apply(blob))));
        request = this.authSigner.signForTemporaryAccess(request, timeInSeconds);
        return BlobStoreUtils.cleanRequest(request);
    }
}

