/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.client.structures;

import com.backblaze.b2.json.B2Json;
import java.util.Objects;

public class B2ListPartsRequest {
    @B2Json.required
    private final String fileId;
    @B2Json.optional
    private final Integer startPartNumber;
    @B2Json.optional
    private final Integer maxPartCount;

    @B2Json.constructor(params="fileId,startPartNumber,maxPartCount")
    public B2ListPartsRequest(String fileId, Integer startPartNumber, Integer maxPartCount) {
        this.fileId = fileId;
        this.startPartNumber = startPartNumber;
        this.maxPartCount = maxPartCount;
    }

    public String getFileId() {
        return this.fileId;
    }

    public Integer getStartPartNumber() {
        return this.startPartNumber;
    }

    public Integer getMaxPartCount() {
        return this.maxPartCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        B2ListPartsRequest that = (B2ListPartsRequest)o;
        return Objects.equals(this.getFileId(), that.getFileId()) && Objects.equals(this.getStartPartNumber(), that.getStartPartNumber()) && Objects.equals(this.getMaxPartCount(), that.getMaxPartCount());
    }

    public int hashCode() {
        return Objects.hash(this.getFileId(), this.getStartPartNumber(), this.getMaxPartCount());
    }

    public static Builder builder(String largeFileId) {
        return new Builder(largeFileId);
    }

    public static Builder builder(B2ListPartsRequest origRequest) {
        return new Builder(origRequest);
    }

    public static class Builder {
        private final String fileId;
        private Integer startPartNumber;
        private Integer maxPartCount;

        public Builder(String fileId) {
            this.fileId = fileId;
        }

        public Builder(B2ListPartsRequest origRequest) {
            this(origRequest.fileId);
            this.setStartPartNumber(origRequest.startPartNumber);
            this.setMaxPartCount(origRequest.maxPartCount);
        }

        public B2ListPartsRequest build() {
            return new B2ListPartsRequest(this.fileId, this.startPartNumber, this.maxPartCount);
        }

        public Builder setStartPartNumber(Integer startPartNumber) {
            this.startPartNumber = startPartNumber;
            return this;
        }

        public Builder setMaxPartCount(Integer maxPartCount) {
            this.maxPartCount = maxPartCount;
            return this;
        }
    }
}

