/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.client;

import com.backblaze.b2.client.B2AccountAuthorizer;
import com.backblaze.b2.client.B2AccountAuthorizerSimpleImpl;
import com.backblaze.b2.client.structures.B2TestMode;
import com.backblaze.b2.util.B2Preconditions;
import java.util.Objects;

public class B2ClientConfig {
    private final B2AccountAuthorizer accountAuthorizer;
    private final String userAgent;
    private final String masterUrl;
    private final B2TestMode testModeOrNull;

    private B2ClientConfig(B2AccountAuthorizer accountAuthorizer, String userAgent, String masterUrl, B2TestMode testModeOrNull) {
        B2Preconditions.checkArgument(userAgent != null && userAgent.length() > 0);
        this.accountAuthorizer = accountAuthorizer;
        this.userAgent = userAgent;
        this.masterUrl = masterUrl;
        this.testModeOrNull = testModeOrNull;
    }

    public B2AccountAuthorizer getAccountAuthorizer() {
        return this.accountAuthorizer;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public String getMasterUrl() {
        return this.masterUrl;
    }

    public B2TestMode getTestModeOrNull() {
        return this.testModeOrNull;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        B2ClientConfig that = (B2ClientConfig)o;
        return Objects.equals(this.getAccountAuthorizer(), that.getAccountAuthorizer()) && Objects.equals(this.getUserAgent(), that.getUserAgent()) && Objects.equals(this.getMasterUrl(), that.getMasterUrl()) && this.getTestModeOrNull() == that.getTestModeOrNull();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getAccountAuthorizer(), this.getUserAgent(), this.getMasterUrl(), this.getTestModeOrNull()});
    }

    public static Builder builder(B2AccountAuthorizer accountAuthorizer, String userAgent) {
        return new Builder(accountAuthorizer, userAgent);
    }

    public static Builder builder(String applicationKeyId, String applicationKey, String userAgent) {
        return new Builder(B2AccountAuthorizerSimpleImpl.builder(applicationKeyId, applicationKey).build(), userAgent);
    }

    public static class Builder {
        private final B2AccountAuthorizer accountAuthorizer;
        private final String userAgent;
        private String masterUrl;
        private B2TestMode testModeOrNull;

        public Builder(B2AccountAuthorizer accountAuthorizer, String userAgent) {
            this.accountAuthorizer = accountAuthorizer;
            this.userAgent = userAgent;
        }

        public Builder setMasterUrl(String masterUrl) {
            this.masterUrl = masterUrl;
            return this;
        }

        public Builder setTestModeOrNull(B2TestMode testModeOrNull) {
            this.testModeOrNull = testModeOrNull;
            return this;
        }

        public B2ClientConfig build() {
            return new B2ClientConfig(this.accountAuthorizer, this.userAgent, this.masterUrl, this.testModeOrNull);
        }
    }
}

