/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.json;

import com.backblaze.b2.json.B2JsonException;
import com.backblaze.b2.json.B2JsonOptions;
import com.backblaze.b2.json.B2JsonReader;
import com.backblaze.b2.json.B2JsonTypeHandler;
import com.backblaze.b2.json.B2JsonWriter;
import java.io.IOException;
import java.lang.reflect.Type;

public class B2JsonDoubleHandler
implements B2JsonTypeHandler<Double> {
    private final boolean isPrimitive;

    public B2JsonDoubleHandler(boolean isPrimitive) {
        this.isPrimitive = isPrimitive;
    }

    @Override
    public Type getHandledType() {
        return Double.class;
    }

    @Override
    public void serialize(Double obj, B2JsonOptions options, B2JsonWriter out) throws IOException {
        out.writeText(obj.toString());
    }

    @Override
    public Double deserialize(B2JsonReader in, B2JsonOptions options) throws B2JsonException, IOException {
        String str = in.readNumberAsString();
        return this.deserializeUrlParam(str);
    }

    @Override
    public Double deserializeUrlParam(String str) throws B2JsonException {
        try {
            return Double.valueOf(str);
        }
        catch (NumberFormatException e) {
            throw new B2JsonException("bad Double: " + str);
        }
    }

    @Override
    public Double defaultValueForOptional() {
        if (this.isPrimitive) {
            return 0.0;
        }
        return null;
    }

    @Override
    public boolean isStringInJson() {
        return false;
    }
}

