/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.json;

import com.backblaze.b2.json.B2JsonException;
import com.backblaze.b2.json.B2JsonOptions;
import com.backblaze.b2.json.B2JsonReader;
import com.backblaze.b2.json.B2JsonTypeHandler;
import com.backblaze.b2.json.B2JsonWriter;
import java.io.IOException;
import java.lang.reflect.Type;

public class B2JsonBooleanHandler
implements B2JsonTypeHandler<Boolean> {
    private final boolean isPrimitive;

    public B2JsonBooleanHandler(boolean isPrimitive) {
        this.isPrimitive = isPrimitive;
    }

    @Override
    public Type getHandledType() {
        return Boolean.class;
    }

    @Override
    public void serialize(Boolean obj, B2JsonOptions options, B2JsonWriter out) throws IOException {
        out.writeText(obj.toString());
    }

    @Override
    public Boolean deserialize(B2JsonReader in, B2JsonOptions options) throws B2JsonException, IOException {
        char c = in.peekNextNotWhitespaceChar();
        if (c == 'f') {
            in.readFalse();
            return false;
        }
        if (c == 't') {
            in.readTrue();
            return true;
        }
        throw new B2JsonException("expected boolean, but next char was " + c);
    }

    @Override
    public Boolean deserializeUrlParam(String urlValue) throws B2JsonException {
        if ("true".equals(urlValue)) {
            return true;
        }
        if ("false".equals(urlValue)) {
            return false;
        }
        throw new B2JsonException("expected boolean, but value was " + urlValue);
    }

    @Override
    public Boolean defaultValueForOptional() {
        if (this.isPrimitive) {
            return false;
        }
        return null;
    }

    @Override
    public boolean isStringInJson() {
        return false;
    }
}

