/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.client;

import com.backblaze.b2.client.B2AccountAuthorizationCache;
import com.backblaze.b2.client.B2ByteProgressFilteringListener;
import com.backblaze.b2.client.B2ContentSourceWithByteProgressListener;
import com.backblaze.b2.client.B2PartOfContentSource;
import com.backblaze.b2.client.B2PartSizes;
import com.backblaze.b2.client.B2PartSpec;
import com.backblaze.b2.client.B2RetryPolicy;
import com.backblaze.b2.client.B2Retryer;
import com.backblaze.b2.client.B2StorageClientWebifier;
import com.backblaze.b2.client.B2UploadPartUrlCache;
import com.backblaze.b2.client.B2UploadProgressAdapter;
import com.backblaze.b2.client.B2UploadProgressUtil;
import com.backblaze.b2.client.contentSources.B2ContentSource;
import com.backblaze.b2.client.exceptions.B2Exception;
import com.backblaze.b2.client.exceptions.B2LocalException;
import com.backblaze.b2.client.structures.B2FileVersion;
import com.backblaze.b2.client.structures.B2FinishLargeFileRequest;
import com.backblaze.b2.client.structures.B2Part;
import com.backblaze.b2.client.structures.B2StartLargeFileRequest;
import com.backblaze.b2.client.structures.B2UploadFileRequest;
import com.backblaze.b2.client.structures.B2UploadPartRequest;
import com.backblaze.b2.client.structures.B2UploadPartUrlResponse;
import com.backblaze.b2.client.structures.B2UploadState;
import com.backblaze.b2.util.B2Collections;
import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;

class B2LargeFileUploader {
    private final B2Retryer retryer;
    private final B2StorageClientWebifier webifier;
    private final B2AccountAuthorizationCache accountAuthCache;
    private final Supplier<B2RetryPolicy> retryPolicySupplier;
    private final ExecutorService executor;
    private final B2PartSizes partSizes;
    private final B2UploadFileRequest request;
    private final long contentLength;

    B2LargeFileUploader(B2Retryer retryer, B2StorageClientWebifier webifier, B2AccountAuthorizationCache accountAuthCache, Supplier<B2RetryPolicy> retryPolicySupplier, ExecutorService executor, B2PartSizes partSizes, B2UploadFileRequest request, long contentLength) {
        this.retryer = retryer;
        this.webifier = webifier;
        this.accountAuthCache = accountAuthCache;
        this.retryPolicySupplier = retryPolicySupplier;
        this.executor = executor;
        this.partSizes = partSizes;
        this.request = request;
        this.contentLength = contentLength;
    }

    B2FileVersion uploadLargeFile() throws B2Exception {
        List<B2PartSpec> allPartSpecs = this.partSizes.pickParts(this.contentLength);
        B2FileVersion largeFileVersion = this.retryer.doRetry("b2_start_large_file", this.accountAuthCache, () -> this.webifier.startLargeFile(this.accountAuthCache.get(), B2StartLargeFileRequest.buildFrom(this.request)), this.retryPolicySupplier.get());
        Map<B2PartSpec, B2Part> uploadedAlready = B2Collections.mapOf();
        return this.uploadPartsAndFinish(largeFileVersion, allPartSpecs, uploadedAlready);
    }

    B2FileVersion finishUploadingLargeFile(B2FileVersion largeFileVersion, List<B2Part> alreadyUploadedParts) throws B2Exception {
        B2LargeFileUploader.throwIfLargeFileVersionDoesntSeemToMatchRequest(largeFileVersion, this.contentLength, this.request);
        alreadyUploadedParts.sort(Comparator.comparingInt(B2Part::getPartNumber));
        List<B2PartSpec> allPartSpecs = this.partSizes.pickParts(this.contentLength);
        TreeMap<B2PartSpec, B2Part> alreadyUploadedSpecs = new TreeMap<B2PartSpec, B2Part>();
        int iUploadedPart = 0;
        for (int iPartSpec = 0; iPartSpec < allPartSpecs.size() && iUploadedPart < alreadyUploadedParts.size(); ++iPartSpec) {
            B2Part alreadyUploadedPart;
            B2PartSpec partSpec = allPartSpecs.get(iPartSpec);
            if (!this.similarEnough(partSpec, alreadyUploadedPart = alreadyUploadedParts.get(iUploadedPart))) continue;
            alreadyUploadedSpecs.put(partSpec, alreadyUploadedPart);
            ++iUploadedPart;
        }
        return this.uploadPartsAndFinish(largeFileVersion, allPartSpecs, alreadyUploadedSpecs);
    }

    static void throwIfLargeFileVersionDoesntSeemToMatchRequest(B2FileVersion largeFileVersion, long contentLength, B2UploadFileRequest request) throws B2Exception {
        B2LargeFileUploader.throwIfMismatch("fileName", request.getFileName(), largeFileVersion.getFileName());
        B2LargeFileUploader.throwIfMismatch("sha1", B2LargeFileUploader.getSha1FromRequest(request), largeFileVersion.getLargeFileSha1OrNull());
        if (!request.getContentType().equals("b2/x-auto")) {
            B2LargeFileUploader.throwIfMismatch("contentType", request.getContentType(), largeFileVersion.getContentType());
        }
        TreeMap<String, String> infos = new TreeMap<String, String>();
        infos.putAll(largeFileVersion.getFileInfo());
        infos.remove("X-Bz-Info-large_file_sha1");
        B2LargeFileUploader.throwIfMismatch("fileInfo", B2LargeFileUploader.toString(request.getFileInfo()), B2LargeFileUploader.toString(infos));
    }

    private static void throwIfMismatch(String name, String contentSourceValue, String largeFileVersionValue) throws B2LocalException {
        if (!Objects.equals(contentSourceValue, largeFileVersionValue)) {
            throw new B2LocalException("mismatch", "contentSource has " + name + " '" + contentSourceValue + "', but largeFileVersion has '" + largeFileVersionValue + "'");
        }
    }

    private static String toString(Map<String, String> map) {
        StringBuilder builder = new StringBuilder();
        builder.append("{\n");
        for (String key : map.keySet()) {
            builder.append("  ");
            builder.append(key);
            builder.append("=");
            builder.append(map.get(key));
            builder.append("\n");
        }
        builder.append("}");
        return builder.toString();
    }

    private static String getSha1FromRequest(B2UploadFileRequest request) throws B2Exception {
        try {
            return request.getContentSource().getSha1OrNull();
        }
        catch (IOException e) {
            throw new B2LocalException("trouble", "failed to get large file's sha1: " + e, e);
        }
    }

    private boolean similarEnough(B2PartSpec partSpec, B2Part alreadyUploadedPart) {
        return partSpec.partNumber == alreadyUploadedPart.getPartNumber() && partSpec.length == alreadyUploadedPart.getContentLength();
    }

    /*
     * Exception decompiling
     */
    private B2FileVersion uploadPartsAndFinish(B2FileVersion largeFileVersion, List<B2PartSpec> allPartSpecs, Map<B2PartSpec, B2Part> uploadedAlready) throws B2Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private B2Part uploadOnePart(B2UploadPartUrlCache uploadPartUrlCache, B2UploadFileRequest request, int partCount, B2PartSpec partSpec) throws B2Exception {
        return this.retryer.doRetry("b2_upload_part", this.accountAuthCache, isRetry -> {
            B2UploadProgressAdapter progressAdapter = new B2UploadProgressAdapter(request.getListener(), partSpec.getPartNumber() - 1, partCount, partSpec.getStart(), partSpec.getLength());
            B2ByteProgressFilteringListener progressListener = new B2ByteProgressFilteringListener(progressAdapter);
            try {
                B2UploadPartUrlResponse uploadPartUrlResponse = uploadPartUrlCache.get(isRetry);
                request.getListener().progress(B2UploadProgressUtil.forPart(partSpec, partCount, 0L, B2UploadState.STARTING));
                B2ContentSource overallSource = request.getContentSource();
                B2ContentSource source = overallSource.createContentSourceWithRangeOrNull(partSpec.start, partSpec.length);
                if (source == null) {
                    source = new B2PartOfContentSource(overallSource, partSpec.start, partSpec.length);
                }
                source = new B2ContentSourceWithByteProgressListener(source, progressListener);
                B2UploadPartRequest partRequest = B2UploadPartRequest.builder(partSpec.partNumber, source).build();
                B2Part part = this.webifier.uploadPart(uploadPartUrlResponse, partRequest);
                uploadPartUrlCache.unget(uploadPartUrlResponse);
                request.getListener().progress(B2UploadProgressUtil.forPartSucceeded(partSpec, partCount));
                return part;
            }
            catch (Exception e) {
                request.getListener().progress(B2UploadProgressUtil.forPartFailed(partSpec, partCount, progressListener.getBytesSoFar()));
                throw e;
            }
        }, this.retryPolicySupplier.get());
    }

    private /* synthetic */ B2FileVersion lambda$uploadPartsAndFinish$3(B2FinishLargeFileRequest finishRequest) throws Exception {
        return this.webifier.finishLargeFile(this.accountAuthCache.get(), finishRequest);
    }

    private static /* synthetic */ B2Part lambda$uploadPartsAndFinish$2(B2Part alreadyUploadedPart) throws Exception {
        return alreadyUploadedPart;
    }

    private /* synthetic */ B2Part lambda$uploadPartsAndFinish$1(B2UploadPartUrlCache uploadPartUrlCache, int partCount, B2PartSpec partSpec) throws Exception {
        return this.uploadOnePart(uploadPartUrlCache, this.request, partCount, partSpec);
    }
}

