/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.validation;

import org.bson.Document;
import org.springframework.data.mongodb.core.query.SerializationUtils;
import org.springframework.data.mongodb.core.validation.Validator;
import org.springframework.util.Assert;

class DocumentValidator
implements Validator {
    private final Document validatorObject;

    static DocumentValidator of(Document validatorObject) {
        Assert.notNull((Object)validatorObject, "ValidatorObject must not be null!");
        return new DocumentValidator(new Document(validatorObject));
    }

    @Override
    public Document toDocument() {
        return new Document(this.validatorObject);
    }

    public String toString() {
        return SerializationUtils.serializeToJsonSafely(this.validatorObject);
    }

    private DocumentValidator(Document validatorObject) {
        this.validatorObject = validatorObject;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DocumentValidator)) {
            return false;
        }
        DocumentValidator other = (DocumentValidator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Document this$validatorObject = this.validatorObject;
        Document other$validatorObject = other.validatorObject;
        return !(this$validatorObject == null ? other$validatorObject != null : !((Object)this$validatorObject).equals(other$validatorObject));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DocumentValidator;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Document $validatorObject = this.validatorObject;
        result = result * 59 + ($validatorObject == null ? 43 : ((Object)$validatorObject).hashCode());
        return result;
    }
}

