/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.messaging;

import org.springframework.data.mongodb.core.messaging.Message;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

class SimpleMessage<S, T>
implements Message<S, T> {
    @Nullable
    private final S raw;
    @Nullable
    private final T body;
    private final Message.MessageProperties properties;

    SimpleMessage(@Nullable S raw, @Nullable T body, Message.MessageProperties properties) {
        Assert.notNull((Object)properties, "Properties must not be null! Use MessageProperties.empty() instead.");
        this.raw = raw;
        this.body = body;
        this.properties = properties;
    }

    @Override
    public S getRaw() {
        return this.raw;
    }

    @Override
    public T getBody() {
        return this.body;
    }

    @Override
    public Message.MessageProperties getProperties() {
        return this.properties;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SimpleMessage)) {
            return false;
        }
        SimpleMessage other = (SimpleMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        S this$raw = this.getRaw();
        S other$raw = other.getRaw();
        if (this$raw == null ? other$raw != null : !this$raw.equals(other$raw)) {
            return false;
        }
        T this$body = this.getBody();
        T other$body = other.getBody();
        if (this$body == null ? other$body != null : !this$body.equals(other$body)) {
            return false;
        }
        Message.MessageProperties this$properties = this.getProperties();
        Message.MessageProperties other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SimpleMessage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        S $raw = this.getRaw();
        result = result * 59 + ($raw == null ? 43 : $raw.hashCode());
        T $body = this.getBody();
        result = result * 59 + ($body == null ? 43 : $body.hashCode());
        Message.MessageProperties $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        return result;
    }

    public String toString() {
        return "SimpleMessage(raw=" + this.getRaw() + ", body=" + this.getBody() + ", properties=" + this.getProperties() + ")";
    }
}

