/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.mapreduce;

import java.util.Iterator;
import java.util.List;
import org.bson.Document;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class GroupByResults<T>
implements Iterable<T> {
    private final List<T> mappedResults;
    private final Document rawResults;
    private double count;
    private int keys;
    @Nullable
    private String serverUsed;

    public GroupByResults(List<T> mappedResults, Document rawResults) {
        Assert.notNull(mappedResults, "List of mapped results must not be null!");
        Assert.notNull((Object)rawResults, "Raw results must not be null!");
        this.mappedResults = mappedResults;
        this.rawResults = rawResults;
        this.parseKeys();
        this.parseCount();
        this.parseServerUsed();
    }

    public double getCount() {
        return this.count;
    }

    public int getKeys() {
        return this.keys;
    }

    @Nullable
    public String getServerUsed() {
        return this.serverUsed;
    }

    @Override
    public Iterator<T> iterator() {
        return this.mappedResults.iterator();
    }

    public Document getRawResults() {
        return this.rawResults;
    }

    private void parseCount() {
        Object object = this.rawResults.get("count");
        if (object instanceof Number) {
            this.count = ((Number)object).doubleValue();
        }
    }

    private void parseKeys() {
        Object object = this.rawResults.get("keys");
        if (object instanceof Number) {
            this.keys = ((Number)object).intValue();
        }
    }

    private void parseServerUsed() {
        Object object = this.rawResults.get("serverUsed");
        if (object instanceof String) {
            this.serverUsed = (String)object;
        }
    }
}

