/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.index;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PropertyHandler;
import org.springframework.data.mongodb.core.index.CompoundIndex;
import org.springframework.data.mongodb.core.index.CompoundIndexDefinition;
import org.springframework.data.mongodb.core.index.CompoundIndexes;
import org.springframework.data.mongodb.core.index.GeoSpatialIndexed;
import org.springframework.data.mongodb.core.index.GeospatialIndex;
import org.springframework.data.mongodb.core.index.Index;
import org.springframework.data.mongodb.core.index.IndexDefinition;
import org.springframework.data.mongodb.core.index.IndexDirection;
import org.springframework.data.mongodb.core.index.IndexResolver;
import org.springframework.data.mongodb.core.index.Indexed;
import org.springframework.data.mongodb.core.index.TextIndexDefinition;
import org.springframework.data.mongodb.core.index.TextIndexed;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.MongoMappingContext;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class MongoPersistentEntityIndexResolver
implements IndexResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(MongoPersistentEntityIndexResolver.class);
    private final MongoMappingContext mappingContext;

    public MongoPersistentEntityIndexResolver(MongoMappingContext mappingContext) {
        Assert.notNull((Object)mappingContext, "Mapping context must not be null in order to resolve index definitions");
        this.mappingContext = mappingContext;
    }

    @Override
    public Iterable<? extends IndexDefinitionHolder> resolveIndexFor(TypeInformation<?> typeInformation) {
        return this.resolveIndexForEntity((MongoPersistentEntity)this.mappingContext.getRequiredPersistentEntity(typeInformation));
    }

    public List<IndexDefinitionHolder> resolveIndexForEntity(MongoPersistentEntity<?> root) {
        Assert.notNull(root, "Index cannot be resolved for given 'null' entity.");
        Document document = root.findAnnotation(Document.class);
        Assert.notNull((Object)document, "Given entity is not collection root.");
        ArrayList<IndexDefinitionHolder> indexInformation = new ArrayList<IndexDefinitionHolder>();
        indexInformation.addAll(this.potentiallyCreateCompoundIndexDefinitions("", root.getCollection(), root));
        indexInformation.addAll(this.potentiallyCreateTextIndexDefinition(root));
        root.doWithProperties(property -> this.potentiallyAddIndexForProperty(root, (MongoPersistentProperty)property, (List<IndexDefinitionHolder>)indexInformation, new CycleGuard()));
        indexInformation.addAll(this.resolveIndexesForDbrefs("", root.getCollection(), root));
        return indexInformation;
    }

    private void potentiallyAddIndexForProperty(MongoPersistentEntity<?> root, MongoPersistentProperty persistentProperty, List<IndexDefinitionHolder> indexes, CycleGuard guard) {
        try {
            IndexDefinitionHolder indexDefinitionHolder;
            if (persistentProperty.isEntity()) {
                indexes.addAll(this.resolveIndexForClass(persistentProperty.getTypeInformation().getActualType(), persistentProperty.getFieldName(), CycleGuard.Path.of(persistentProperty), root.getCollection(), guard));
            }
            if ((indexDefinitionHolder = this.createIndexDefinitionHolderForProperty(persistentProperty.getFieldName(), root.getCollection(), persistentProperty)) != null) {
                indexes.add(indexDefinitionHolder);
            }
        }
        catch (CyclicPropertyReferenceException e) {
            LOGGER.info(e.getMessage());
        }
    }

    private List<IndexDefinitionHolder> resolveIndexForClass(TypeInformation<?> type, String dotPath, CycleGuard.Path path, String collection, CycleGuard guard) {
        MongoPersistentEntity entity = (MongoPersistentEntity)this.mappingContext.getRequiredPersistentEntity(type);
        ArrayList<IndexDefinitionHolder> indexInformation = new ArrayList<IndexDefinitionHolder>();
        indexInformation.addAll(this.potentiallyCreateCompoundIndexDefinitions(dotPath, collection, entity));
        entity.doWithProperties(property -> this.guradAndPotentiallyAddIndexForProperty((MongoPersistentProperty)property, dotPath, path, collection, (List<IndexDefinitionHolder>)indexInformation, guard));
        indexInformation.addAll(this.resolveIndexesForDbrefs(dotPath, collection, entity));
        return indexInformation;
    }

    private void guradAndPotentiallyAddIndexForProperty(MongoPersistentProperty persistentProperty, String dotPath, CycleGuard.Path path, String collection, List<IndexDefinitionHolder> indexes, CycleGuard guard) {
        IndexDefinitionHolder indexDefinitionHolder;
        String propertyDotPath = (StringUtils.hasText(dotPath) ? dotPath + "." : "") + persistentProperty.getFieldName();
        CycleGuard.Path propertyPath = path.append(persistentProperty);
        guard.protect(persistentProperty, propertyPath);
        if (persistentProperty.isEntity()) {
            try {
                indexes.addAll(this.resolveIndexForClass(persistentProperty.getTypeInformation().getActualType(), propertyDotPath, propertyPath, collection, guard));
            }
            catch (CyclicPropertyReferenceException e) {
                LOGGER.info(e.getMessage());
            }
        }
        if ((indexDefinitionHolder = this.createIndexDefinitionHolderForProperty(propertyDotPath, collection, persistentProperty)) != null) {
            indexes.add(indexDefinitionHolder);
        }
    }

    @Nullable
    private IndexDefinitionHolder createIndexDefinitionHolderForProperty(String dotPath, String collection, MongoPersistentProperty persistentProperty) {
        if (persistentProperty.isAnnotationPresent(Indexed.class)) {
            return this.createIndexDefinition(dotPath, collection, persistentProperty);
        }
        if (persistentProperty.isAnnotationPresent(GeoSpatialIndexed.class)) {
            return this.createGeoSpatialIndexDefinition(dotPath, collection, persistentProperty);
        }
        return null;
    }

    private List<IndexDefinitionHolder> potentiallyCreateCompoundIndexDefinitions(String dotPath, String collection, MongoPersistentEntity<?> entity) {
        if (entity.findAnnotation(CompoundIndexes.class) == null && entity.findAnnotation(CompoundIndex.class) == null) {
            return Collections.emptyList();
        }
        return this.createCompoundIndexDefinitions(dotPath, collection, entity);
    }

    private Collection<? extends IndexDefinitionHolder> potentiallyCreateTextIndexDefinition(MongoPersistentEntity<?> root) {
        String name = root.getType().getSimpleName() + "_TextIndex";
        if (name.getBytes().length > 127) {
            String[] args = ClassUtils.getShortNameAsProperty(root.getType()).split("\\.");
            name = "";
            Iterator<String> it = Arrays.asList(args).iterator();
            while (it.hasNext()) {
                if (!it.hasNext()) {
                    name = name + it.next() + "_TextIndex";
                    continue;
                }
                name = name + it.next().charAt(0) + ".";
            }
        }
        TextIndexDefinition.TextIndexDefinitionBuilder indexDefinitionBuilder = new TextIndexDefinition.TextIndexDefinitionBuilder().named(name);
        if (StringUtils.hasText(root.getLanguage())) {
            indexDefinitionBuilder.withDefaultLanguage(root.getLanguage());
        }
        try {
            this.appendTextIndexInformation("", CycleGuard.Path.empty(), indexDefinitionBuilder, root, new TextIndexIncludeOptions(TextIndexIncludeOptions.IncludeStrategy.DEFAULT), new CycleGuard());
        }
        catch (CyclicPropertyReferenceException e) {
            LOGGER.info(e.getMessage());
        }
        TextIndexDefinition indexDefinition = indexDefinitionBuilder.build();
        if (!indexDefinition.hasFieldSpec()) {
            return Collections.emptyList();
        }
        IndexDefinitionHolder holder = new IndexDefinitionHolder("", indexDefinition, root.getCollection());
        return Collections.singletonList(holder);
    }

    private void appendTextIndexInformation(final String dotPath, final CycleGuard.Path path, final TextIndexDefinition.TextIndexDefinitionBuilder indexDefinitionBuilder, final MongoPersistentEntity<?> entity, final TextIndexIncludeOptions includeOptions, final CycleGuard guard) {
        entity.doWithProperties(new PropertyHandler<MongoPersistentProperty>(){

            @Override
            public void doWithPersistentProperty(MongoPersistentProperty persistentProperty) {
                guard.protect(persistentProperty, path);
                if (persistentProperty.isExplicitLanguageProperty() && !StringUtils.hasText(dotPath)) {
                    indexDefinitionBuilder.withLanguageOverride(persistentProperty.getFieldName());
                }
                TextIndexed indexed = persistentProperty.findAnnotation(TextIndexed.class);
                if (includeOptions.isForce() || indexed != null || persistentProperty.isEntity()) {
                    String propertyDotPath = (StringUtils.hasText(dotPath) ? dotPath + "." : "") + persistentProperty.getFieldName();
                    CycleGuard.Path propertyPath = path.append(persistentProperty);
                    TextIndexDefinition.TextIndexedFieldSpec parentFieldSpec = includeOptions.getParentFieldSpec();
                    Float weight = Float.valueOf(indexed != null ? indexed.weight() : (parentFieldSpec != null ? parentFieldSpec.getWeight().floatValue() : 1.0f));
                    if (persistentProperty.isEntity()) {
                        TextIndexIncludeOptions optionsForNestedType = includeOptions;
                        if (!TextIndexIncludeOptions.IncludeStrategy.FORCE.equals((Object)includeOptions.getStrategy()) && indexed != null) {
                            optionsForNestedType = new TextIndexIncludeOptions(TextIndexIncludeOptions.IncludeStrategy.FORCE, new TextIndexDefinition.TextIndexedFieldSpec(propertyDotPath, weight));
                        }
                        try {
                            MongoPersistentEntityIndexResolver.this.appendTextIndexInformation(propertyDotPath, propertyPath, indexDefinitionBuilder, (MongoPersistentEntity)MongoPersistentEntityIndexResolver.this.mappingContext.getPersistentEntity((Class)persistentProperty.getActualType()), optionsForNestedType, guard);
                        }
                        catch (CyclicPropertyReferenceException e) {
                            LOGGER.info(e.getMessage());
                        }
                        catch (InvalidDataAccessApiUsageException e) {
                            LOGGER.info(String.format("Potentially invalid index structure discovered. Breaking operation for %s.", entity.getName()), e);
                        }
                    } else if (includeOptions.isForce() || indexed != null) {
                        indexDefinitionBuilder.onField(propertyDotPath, weight);
                    }
                }
            }
        });
    }

    protected List<IndexDefinitionHolder> createCompoundIndexDefinitions(String dotPath, String fallbackCollection, MongoPersistentEntity<?> entity) {
        CompoundIndex index2;
        List<IndexDefinitionHolder> indexDefinitions = new ArrayList<IndexDefinitionHolder>();
        CompoundIndexes indexes = entity.findAnnotation(CompoundIndexes.class);
        if (indexes != null) {
            indexDefinitions = Arrays.stream(indexes.value()).map(index -> this.createCompoundIndexDefinition(dotPath, fallbackCollection, (CompoundIndex)index, entity)).collect(Collectors.toList());
        }
        if ((index2 = entity.findAnnotation(CompoundIndex.class)) != null) {
            indexDefinitions.add(this.createCompoundIndexDefinition(dotPath, fallbackCollection, index2, entity));
        }
        return indexDefinitions;
    }

    protected IndexDefinitionHolder createCompoundIndexDefinition(String dotPath, String collection, CompoundIndex index, MongoPersistentEntity<?> entity) {
        CompoundIndexDefinition indexDefinition = new CompoundIndexDefinition(this.resolveCompoundIndexKeyFromStringDefinition(dotPath, index.def()));
        if (!index.useGeneratedName()) {
            indexDefinition.named(this.pathAwareIndexName(index.name(), dotPath, null));
        }
        if (index.unique()) {
            indexDefinition.unique();
        }
        if (index.sparse()) {
            indexDefinition.sparse();
        }
        if (index.background()) {
            indexDefinition.background();
        }
        return new IndexDefinitionHolder(dotPath, indexDefinition, collection);
    }

    private org.bson.Document resolveCompoundIndexKeyFromStringDefinition(String dotPath, String keyDefinitionString) {
        if (!StringUtils.hasText(dotPath) && !StringUtils.hasText(keyDefinitionString)) {
            throw new InvalidDataAccessApiUsageException("Cannot create index on root level for empty keys.");
        }
        if (!StringUtils.hasText(keyDefinitionString)) {
            return new org.bson.Document(dotPath, 1);
        }
        org.bson.Document dbo = org.bson.Document.parse(keyDefinitionString);
        if (!StringUtils.hasText(dotPath)) {
            return dbo;
        }
        org.bson.Document document = new org.bson.Document();
        for (String key : dbo.keySet()) {
            document.put(dotPath + "." + key, dbo.get(key));
        }
        return document;
    }

    @Nullable
    protected IndexDefinitionHolder createIndexDefinition(String dotPath, String collection, MongoPersistentProperty persitentProperty) {
        Indexed index = persitentProperty.findAnnotation(Indexed.class);
        if (index == null) {
            return null;
        }
        Index indexDefinition = new Index().on(dotPath, IndexDirection.ASCENDING.equals((Object)index.direction()) ? Sort.Direction.ASC : Sort.Direction.DESC);
        if (!index.useGeneratedName()) {
            indexDefinition.named(this.pathAwareIndexName(index.name(), dotPath, persitentProperty));
        }
        if (index.unique()) {
            indexDefinition.unique();
        }
        if (index.sparse()) {
            indexDefinition.sparse();
        }
        if (index.background()) {
            indexDefinition.background();
        }
        if (index.expireAfterSeconds() >= 0) {
            indexDefinition.expire(index.expireAfterSeconds(), TimeUnit.SECONDS);
        }
        return new IndexDefinitionHolder(dotPath, indexDefinition, collection);
    }

    @Nullable
    protected IndexDefinitionHolder createGeoSpatialIndexDefinition(String dotPath, String collection, MongoPersistentProperty persistentProperty) {
        GeoSpatialIndexed index = persistentProperty.findAnnotation(GeoSpatialIndexed.class);
        if (index == null) {
            return null;
        }
        GeospatialIndex indexDefinition = new GeospatialIndex(dotPath);
        indexDefinition.withBits(index.bits());
        indexDefinition.withMin(index.min()).withMax(index.max());
        if (!index.useGeneratedName()) {
            indexDefinition.named(this.pathAwareIndexName(index.name(), dotPath, persistentProperty));
        }
        indexDefinition.typed(index.type()).withBucketSize(index.bucketSize()).withAdditionalField(index.additionalField());
        return new IndexDefinitionHolder(dotPath, indexDefinition, collection);
    }

    private String pathAwareIndexName(String indexName, String dotPath, @Nullable MongoPersistentProperty property) {
        String nameToUse;
        String string = nameToUse = StringUtils.hasText(indexName) ? indexName : "";
        if (!StringUtils.hasText(dotPath) || property != null && dotPath.equals(property.getFieldName())) {
            return StringUtils.hasText(nameToUse) ? nameToUse : dotPath;
        }
        if (StringUtils.hasText(dotPath)) {
            nameToUse = StringUtils.hasText(nameToUse) ? (property != null ? dotPath.replace("." + property.getFieldName(), "") : dotPath) + "." + nameToUse : dotPath;
        }
        return nameToUse;
    }

    private List<IndexDefinitionHolder> resolveIndexesForDbrefs(String path, String collection, MongoPersistentEntity<?> entity) {
        ArrayList<IndexDefinitionHolder> indexes = new ArrayList<IndexDefinitionHolder>(0);
        entity.doWithAssociations(association -> this.resolveAndAddIndexesForAssociation(association, indexes, path, collection));
        return indexes;
    }

    private void resolveAndAddIndexesForAssociation(Association<MongoPersistentProperty> association, List<IndexDefinitionHolder> indexes, String path, String collection) {
        MongoPersistentProperty property = association.getInverse();
        String propertyDotPath = (StringUtils.hasText(path) ? path + "." : "") + property.getFieldName();
        if (property.isAnnotationPresent(GeoSpatialIndexed.class) || property.isAnnotationPresent(TextIndexed.class)) {
            throw new MappingException(String.format("Cannot create geospatial-/text- index on DBRef in collection '%s' for path '%s'.", collection, propertyDotPath));
        }
        IndexDefinitionHolder indexDefinitionHolder = this.createIndexDefinitionHolderForProperty(propertyDotPath, collection, property);
        if (indexDefinitionHolder != null) {
            indexes.add(indexDefinitionHolder);
        }
    }

    static class TextIndexIncludeOptions {
        private final IncludeStrategy strategy;
        @Nullable
        private final TextIndexDefinition.TextIndexedFieldSpec parentFieldSpec;

        public TextIndexIncludeOptions(IncludeStrategy strategy, @Nullable TextIndexDefinition.TextIndexedFieldSpec parentFieldSpec) {
            this.strategy = strategy;
            this.parentFieldSpec = parentFieldSpec;
        }

        public TextIndexIncludeOptions(IncludeStrategy strategy) {
            this(strategy, null);
        }

        public IncludeStrategy getStrategy() {
            return this.strategy;
        }

        @Nullable
        public TextIndexDefinition.TextIndexedFieldSpec getParentFieldSpec() {
            return this.parentFieldSpec;
        }

        public boolean isForce() {
            return IncludeStrategy.FORCE.equals((Object)this.strategy);
        }

        static enum IncludeStrategy {
            FORCE,
            DEFAULT;

        }
    }

    public static class IndexDefinitionHolder
    implements IndexDefinition {
        private final String path;
        private final IndexDefinition indexDefinition;
        private final String collection;

        public IndexDefinitionHolder(String path, IndexDefinition definition, String collection) {
            this.path = path;
            this.indexDefinition = definition;
            this.collection = collection;
        }

        public String getCollection() {
            return this.collection;
        }

        public String getPath() {
            return this.path;
        }

        public IndexDefinition getIndexDefinition() {
            return this.indexDefinition;
        }

        @Override
        public org.bson.Document getIndexKeys() {
            return this.indexDefinition.getIndexKeys();
        }

        @Override
        public org.bson.Document getIndexOptions() {
            return this.indexDefinition.getIndexOptions();
        }
    }

    public static class CyclicPropertyReferenceException
    extends RuntimeException {
        private static final long serialVersionUID = -3762979307658772277L;
        private final String propertyName;
        @Nullable
        private final Class<?> type;
        private final String dotPath;

        public CyclicPropertyReferenceException(String propertyName, @Nullable Class<?> type, String dotPath) {
            this.propertyName = propertyName;
            this.type = type;
            this.dotPath = dotPath;
        }

        @Override
        public String getMessage() {
            return String.format("Found cycle for field '%s' in type '%s' for path '%s'", this.propertyName, this.type != null ? this.type.getSimpleName() : "unknown", this.dotPath);
        }
    }

    static class CycleGuard {
        private final Set<String> seenProperties = new HashSet<String>();

        CycleGuard() {
        }

        void protect(MongoPersistentProperty property, Path path) throws CyclicPropertyReferenceException {
            String propertyTypeKey = this.createMapKey(property);
            if (!this.seenProperties.add(propertyTypeKey) && path.isCycle()) {
                throw new CyclicPropertyReferenceException(property.getFieldName(), property.getOwner().getType(), path.toCyclePath());
            }
        }

        private String createMapKey(MongoPersistentProperty property) {
            return ClassUtils.getShortName(property.getOwner().getType()) + ":" + property.getFieldName();
        }

        static class Path {
            private static final Path EMPTY = new Path(Collections.emptyList(), false);
            private final List<PersistentProperty<?>> elements;
            private final boolean cycle;

            static Path empty() {
                return EMPTY;
            }

            static Path of(PersistentProperty<?> initial) {
                return new Path(Collections.singletonList(initial), false);
            }

            Path append(PersistentProperty<?> breadcrumb) {
                ArrayList elements = new ArrayList(this.elements.size() + 1);
                elements.addAll(this.elements);
                elements.add(breadcrumb);
                return new Path(elements, this.elements.contains(breadcrumb));
            }

            public boolean isCycle() {
                return this.cycle;
            }

            public String toString() {
                return this.elements.isEmpty() ? "(empty)" : Path.toPath(this.elements.iterator());
            }

            String toCyclePath() {
                if (!this.cycle) {
                    return "";
                }
                for (int i = 0; i < this.elements.size(); ++i) {
                    int index = Path.indexOf(this.elements, this.elements.get(i), i + 1);
                    if (index == -1) continue;
                    return Path.toPath(this.elements.subList(i, index + 1).iterator());
                }
                return this.toString();
            }

            private static <T> int indexOf(List<T> haystack, T needle, int offset) {
                for (int i = offset; i < haystack.size(); ++i) {
                    if (!haystack.get(i).equals(needle)) continue;
                    return i;
                }
                return -1;
            }

            private static String toPath(Iterator<PersistentProperty<?>> iterator) {
                StringBuilder builder = new StringBuilder();
                while (iterator.hasNext()) {
                    builder.append(iterator.next().getName());
                    if (!iterator.hasNext()) continue;
                    builder.append(" -> ");
                }
                return builder.toString();
            }

            private Path(List<PersistentProperty<?>> elements, boolean cycle) {
                this.elements = elements;
                this.cycle = cycle;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Path)) {
                    return false;
                }
                Path other = (Path)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                List<PersistentProperty<?>> this$elements = this.elements;
                List<PersistentProperty<?>> other$elements = other.elements;
                if (this$elements == null ? other$elements != null : !((Object)this$elements).equals(other$elements)) {
                    return false;
                }
                return this.isCycle() == other.isCycle();
            }

            protected boolean canEqual(Object other) {
                return other instanceof Path;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                List<PersistentProperty<?>> $elements = this.elements;
                result = result * 59 + ($elements == null ? 43 : ((Object)$elements).hashCode());
                result = result * 59 + (this.isCycle() ? 79 : 97);
                return result;
            }
        }
    }
}

