/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.index;

import com.mongodb.MongoException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.context.MappingContextEvent;
import org.springframework.data.mongodb.UncategorizedMongoDbException;
import org.springframework.data.mongodb.core.index.IndexInfo;
import org.springframework.data.mongodb.core.index.IndexOperations;
import org.springframework.data.mongodb.core.index.IndexOperationsProvider;
import org.springframework.data.mongodb.core.index.IndexResolver;
import org.springframework.data.mongodb.core.index.MongoPersistentEntityIndexResolver;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.MongoMappingContext;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.util.MongoDbErrorCodes;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class MongoPersistentEntityIndexCreator
implements ApplicationListener<MappingContextEvent<?, ?>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MongoPersistentEntityIndexCreator.class);
    private final Map<Class<?>, Boolean> classesSeen = new ConcurrentHashMap();
    private final IndexOperationsProvider indexOperationsProvider;
    private final MongoMappingContext mappingContext;
    private final IndexResolver indexResolver;

    public MongoPersistentEntityIndexCreator(MongoMappingContext mappingContext, IndexOperationsProvider indexOperationsProvider) {
        this(mappingContext, indexOperationsProvider, new MongoPersistentEntityIndexResolver(mappingContext));
    }

    public MongoPersistentEntityIndexCreator(MongoMappingContext mappingContext, IndexOperationsProvider indexOperationsProvider, IndexResolver indexResolver) {
        Assert.notNull((Object)mappingContext, "MongoMappingContext must not be null!");
        Assert.notNull((Object)indexOperationsProvider, "IndexOperationsProvider must not be null!");
        Assert.notNull((Object)indexResolver, "IndexResolver must not be null!");
        this.indexOperationsProvider = indexOperationsProvider;
        this.mappingContext = mappingContext;
        this.indexResolver = indexResolver;
        for (MongoPersistentEntity entity : mappingContext.getPersistentEntities()) {
            this.checkForIndexes(entity);
        }
    }

    @Override
    public void onApplicationEvent(MappingContextEvent<?, ?> event) {
        if (!event.wasEmittedBy(this.mappingContext)) {
            return;
        }
        Object entity = event.getPersistentEntity();
        if (entity instanceof MongoPersistentEntity) {
            this.checkForIndexes((MongoPersistentEntity)entity);
        }
    }

    private void checkForIndexes(MongoPersistentEntity<?> entity) {
        Class type = entity.getType();
        if (!this.classesSeen.containsKey(type)) {
            this.classesSeen.put(type, Boolean.TRUE);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Analyzing class " + type + " for index information.");
            }
            this.checkForAndCreateIndexes(entity);
        }
    }

    private void checkForAndCreateIndexes(MongoPersistentEntity<?> entity) {
        if (entity.isAnnotationPresent(Document.class)) {
            for (MongoPersistentEntityIndexResolver.IndexDefinitionHolder indexDefinitionHolder : this.indexResolver.resolveIndexFor(entity.getTypeInformation())) {
                this.createIndex(indexDefinitionHolder);
            }
        }
    }

    void createIndex(MongoPersistentEntityIndexResolver.IndexDefinitionHolder indexDefinition) {
        try {
            IndexOperations indexOperations = this.indexOperationsProvider.indexOps(indexDefinition.getCollection());
            indexOperations.ensureIndex(indexDefinition);
        }
        catch (UncategorizedMongoDbException ex) {
            if (ex.getCause() instanceof MongoException && MongoDbErrorCodes.isDataIntegrityViolationCode(((MongoException)ex.getCause()).getCode())) {
                IndexInfo existingIndex = this.fetchIndexInformation(indexDefinition);
                String message = "Cannot create index for '%s' in collection '%s' with keys '%s' and options '%s'.";
                if (existingIndex != null) {
                    message = message + " Index already defined as '%s'.";
                }
                throw new DataIntegrityViolationException(String.format(message, indexDefinition.getPath(), indexDefinition.getCollection(), indexDefinition.getIndexKeys(), indexDefinition.getIndexOptions(), existingIndex), ex.getCause());
            }
            throw ex;
        }
    }

    public boolean isIndexCreatorFor(MappingContext<?, ?> context) {
        return this.mappingContext.equals(context);
    }

    @Nullable
    private IndexInfo fetchIndexInformation(@Nullable MongoPersistentEntityIndexResolver.IndexDefinitionHolder indexDefinition) {
        if (indexDefinition == null) {
            return null;
        }
        try {
            IndexOperations indexOperations = this.indexOperationsProvider.indexOps(indexDefinition.getCollection());
            Object indexNameToLookUp = indexDefinition.getIndexOptions().get("name");
            List<IndexInfo> existingIndexes = indexOperations.getIndexInfo();
            return existingIndexes.stream().filter(indexInfo -> ObjectUtils.nullSafeEquals(indexNameToLookUp, indexInfo.getName())).findFirst().orElse(null);
        }
        catch (Exception e) {
            LOGGER.debug(String.format("Failed to load index information for collection '%s'.", indexDefinition.getCollection()), e);
            return null;
        }
    }
}

