/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.geo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.springframework.data.geo.Point;
import org.springframework.data.mongodb.core.geo.GeoJson;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class GeoJsonMultiPoint
implements GeoJson<Iterable<Point>> {
    private static final String TYPE = "MultiPoint";
    private final List<Point> points;

    public GeoJsonMultiPoint(List<Point> points) {
        Assert.notNull(points, "Points must not be null.");
        Assert.isTrue(points.size() >= 2, "Minimum of 2 Points required.");
        this.points = new ArrayList<Point>(points);
    }

    public GeoJsonMultiPoint(Point first, Point second, Point ... others) {
        Assert.notNull((Object)first, "First point must not be null!");
        Assert.notNull((Object)second, "Second point must not be null!");
        Assert.notNull((Object)others, "Additional points must not be null!");
        this.points = new ArrayList<Point>();
        this.points.add(first);
        this.points.add(second);
        this.points.addAll(Arrays.asList(others));
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public List<Point> getCoordinates() {
        return Collections.unmodifiableList(this.points);
    }

    public int hashCode() {
        return ObjectUtils.nullSafeHashCode(this.points);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GeoJsonMultiPoint)) {
            return false;
        }
        return ObjectUtils.nullSafeEquals(this.points, ((GeoJsonMultiPoint)obj).points);
    }
}

