/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.geo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.data.mongodb.core.geo.GeoJson;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class GeoJsonGeometryCollection
implements GeoJson<Iterable<GeoJson<?>>> {
    private static final String TYPE = "GeometryCollection";
    private final List<GeoJson<?>> geometries = new ArrayList();

    public GeoJsonGeometryCollection(List<GeoJson<?>> geometries) {
        Assert.notNull(geometries, "Geometries must not be null!");
        this.geometries.addAll(geometries);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public Iterable<GeoJson<?>> getCoordinates() {
        return Collections.unmodifiableList(this.geometries);
    }

    public int hashCode() {
        return ObjectUtils.nullSafeHashCode(this.geometries);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GeoJsonGeometryCollection)) {
            return false;
        }
        GeoJsonGeometryCollection other = (GeoJsonGeometryCollection)obj;
        return ObjectUtils.nullSafeEquals(this.geometries, other.geometries);
    }
}

