/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import org.bson.Document;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperationContext;
import org.springframework.data.mongodb.core.query.NearQuery;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class GeoNearOperation
implements AggregationOperation {
    private final NearQuery nearQuery;
    private final String distanceField;
    @Nullable
    private final String indexKey;

    public GeoNearOperation(NearQuery nearQuery, String distanceField) {
        this(nearQuery, distanceField, null);
    }

    private GeoNearOperation(NearQuery nearQuery, String distanceField, @Nullable String indexKey) {
        Assert.notNull((Object)nearQuery, "NearQuery must not be null.");
        Assert.hasLength(distanceField, "Distance field must not be null or empty.");
        this.nearQuery = nearQuery;
        this.distanceField = distanceField;
        this.indexKey = indexKey;
    }

    public GeoNearOperation useIndex(String key) {
        return new GeoNearOperation(this.nearQuery, this.distanceField, key);
    }

    @Override
    public Document toDocument(AggregationOperationContext context) {
        Document command = context.getMappedObject(this.nearQuery.toDocument());
        command.put("distanceField", (Object)this.distanceField);
        if (StringUtils.hasText(this.indexKey)) {
            command.put("key", (Object)this.indexKey);
        }
        return new Document("$geoNear", command);
    }
}

