/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import org.bson.Document;
import org.springframework.data.mongodb.core.aggregation.AggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.ExposedFields;
import org.springframework.data.mongodb.core.aggregation.FieldsExposingAggregationOperation;
import org.springframework.util.Assert;

public class CountOperation
implements FieldsExposingAggregationOperation {
    private final String fieldName;

    public CountOperation(String fieldName) {
        Assert.hasText(fieldName, "Field name must not be null or empty!");
        this.fieldName = fieldName;
    }

    @Override
    public Document toDocument(AggregationOperationContext context) {
        return new Document("$count", this.fieldName);
    }

    @Override
    public ExposedFields getFields() {
        return ExposedFields.from(new ExposedFields.ExposedField(this.fieldName, true));
    }

    public static class CountOperationBuilder {
        public CountOperation as(String fieldName) {
            return new CountOperation(fieldName);
        }
    }
}

