/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.ClientSessionOptions;
import com.mongodb.ConnectionString;
import com.mongodb.DB;
import com.mongodb.client.ClientSession;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoDatabase;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.data.mongodb.core.MongoDbFactorySupport;
import org.springframework.data.mongodb.core.MongoExceptionTranslator;

public class SimpleMongoClientDbFactory
extends MongoDbFactorySupport<MongoClient>
implements DisposableBean {
    public SimpleMongoClientDbFactory(String connectionString) {
        this(new ConnectionString(connectionString));
    }

    public SimpleMongoClientDbFactory(ConnectionString connectionString) {
        this(MongoClients.create(connectionString), connectionString.getDatabase(), true);
    }

    public SimpleMongoClientDbFactory(MongoClient mongoClient, String databaseName) {
        this(mongoClient, databaseName, false);
    }

    private SimpleMongoClientDbFactory(MongoClient mongoClient, String databaseName, boolean mongoInstanceCreated) {
        super(mongoClient, databaseName, mongoInstanceCreated, new MongoExceptionTranslator());
    }

    @Override
    public DB getLegacyDb() {
        throw new UnsupportedOperationException(String.format("%s does not support legacy DBObject API! Please consider using SimpleMongoDbFactory for that purpose.", MongoClient.class));
    }

    @Override
    public ClientSession getSession(ClientSessionOptions options) {
        return ((MongoClient)this.getMongoClient()).startSession(options);
    }

    @Override
    protected void closeClient() {
        ((MongoClient)this.getMongoClient()).close();
    }

    @Override
    protected MongoDatabase doGetMongoDatabase(String dbName) {
        return ((MongoClient)this.getMongoClient()).getDatabase(dbName);
    }
}

