/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.MongoClient;
import com.mongodb.client.MongoDatabase;
import org.bson.Document;
import org.springframework.data.mongodb.core.MongoAdminOperations;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.util.Assert;

@ManagedResource(description="Mongo Admin Operations")
public class MongoAdmin
implements MongoAdminOperations {
    private final MongoClient mongoClient;

    public MongoAdmin(MongoClient mongoClient) {
        Assert.notNull((Object)mongoClient, "MongoClient must not be null!");
        this.mongoClient = mongoClient;
    }

    @Override
    @ManagedOperation
    public void dropDatabase(String databaseName) {
        this.getDB(databaseName).drop();
    }

    @Override
    @ManagedOperation
    public void createDatabase(String databaseName) {
        this.getDB(databaseName);
    }

    @Override
    @ManagedOperation
    public String getDatabaseStats(String databaseName) {
        return this.getDB(databaseName).runCommand(new Document("dbStats", 1).append("scale", 1024)).toJson();
    }

    @ManagedOperation
    public String getServerStatus() {
        return this.getDB("admin").runCommand(new Document("serverStatus", 1).append("rangeDeleter", 1).append("repl", 1)).toJson();
    }

    MongoDatabase getDB(String databaseName) {
        return this.mongoClient.getDatabase(databaseName);
    }
}

