/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.client.model.IndexOptions;
import java.util.concurrent.TimeUnit;
import org.bson.Document;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.mongodb.core.index.IndexDefinition;
import org.springframework.data.mongodb.core.index.IndexInfo;
import org.springframework.data.mongodb.core.query.Collation;
import org.springframework.lang.Nullable;
import org.springframework.util.ObjectUtils;

abstract class IndexConverters {
    private static final Converter<IndexDefinition, IndexOptions> DEFINITION_TO_MONGO_INDEX_OPTIONS = IndexConverters.getIndexDefinitionIndexOptionsConverter();
    private static final Converter<Document, IndexInfo> DOCUMENT_INDEX_INFO = IndexConverters.getDocumentIndexInfoConverter();

    private IndexConverters() {
    }

    static Converter<IndexDefinition, IndexOptions> indexDefinitionToIndexOptionsConverter() {
        return DEFINITION_TO_MONGO_INDEX_OPTIONS;
    }

    static Converter<Document, IndexInfo> documentToIndexInfoConverter() {
        return DOCUMENT_INDEX_INFO;
    }

    private static Converter<IndexDefinition, IndexOptions> getIndexDefinitionIndexOptionsConverter() {
        return indexDefinition -> {
            Document indexOptions = indexDefinition.getIndexOptions();
            IndexOptions ops = new IndexOptions();
            if (indexOptions.containsKey("name")) {
                ops = ops.name(indexOptions.get("name").toString());
            }
            if (indexOptions.containsKey("unique")) {
                ops = ops.unique((Boolean)indexOptions.get("unique"));
            }
            if (indexOptions.containsKey("sparse")) {
                ops = ops.sparse((Boolean)indexOptions.get("sparse"));
            }
            if (indexOptions.containsKey("background")) {
                ops = ops.background((Boolean)indexOptions.get("background"));
            }
            if (indexOptions.containsKey("expireAfterSeconds")) {
                ops = ops.expireAfter((Long)indexOptions.get("expireAfterSeconds"), TimeUnit.SECONDS);
            }
            if (indexOptions.containsKey("min")) {
                ops = ops.min(((Number)indexOptions.get("min")).doubleValue());
            }
            if (indexOptions.containsKey("max")) {
                ops = ops.max(((Number)indexOptions.get("max")).doubleValue());
            }
            if (indexOptions.containsKey("bits")) {
                ops = ops.bits((Integer)indexOptions.get("bits"));
            }
            if (indexOptions.containsKey("bucketSize")) {
                ops = ops.bucketSize(((Number)indexOptions.get("bucketSize")).doubleValue());
            }
            if (indexOptions.containsKey("default_language")) {
                ops = ops.defaultLanguage(indexOptions.get("default_language").toString());
            }
            if (indexOptions.containsKey("language_override")) {
                ops = ops.languageOverride(indexOptions.get("language_override").toString());
            }
            if (indexOptions.containsKey("weights")) {
                ops = ops.weights((Document)indexOptions.get("weights"));
            }
            for (String key : indexOptions.keySet()) {
                if (!ObjectUtils.nullSafeEquals("2dsphere", indexOptions.get(key))) continue;
                ops = ops.sphereVersion(2);
            }
            if (indexOptions.containsKey("partialFilterExpression")) {
                ops = ops.partialFilterExpression((Document)indexOptions.get("partialFilterExpression"));
            }
            if (indexOptions.containsKey("collation")) {
                ops = ops.collation(IndexConverters.fromDocument((Document)((Object)indexOptions.get((Object)"collation", Document.class))));
            }
            return ops;
        };
    }

    @Nullable
    public static com.mongodb.client.model.Collation fromDocument(@Nullable Document source) {
        if (source == null) {
            return null;
        }
        return Collation.from(source).toMongoCollation();
    }

    private static Converter<Document, IndexInfo> getDocumentIndexInfoConverter() {
        return IndexInfo::indexInfoOf;
    }
}

