/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.config;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import com.parablu.config.AppConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.data.mongodb.config.AbstractMongoConfiguration;
import org.springframework.stereotype.Component;

@Component
public class MongoDBConfig
extends AbstractMongoConfiguration {
    @Autowired
    private AppConfig appConfig;

    @Override
    @Bean
    public MongoClient mongoClient() {
        ServerAddress serverAddress = new ServerAddress(this.appConfig.getPropAddress(), Integer.parseInt(this.appConfig.getPropPort()));
        MongoCredential mongoCredential = MongoCredential.createCredential(this.appConfig.getPropUser(), this.getDatabaseName(), this.appConfig.getPropPassword().toCharArray());
        MongoClientOptions mongoClientOptions = new MongoClientOptions.Builder().build();
        MongoClient mongoClient = new MongoClient(serverAddress, mongoCredential, mongoClientOptions);
        return mongoClient;
    }

    @Override
    protected String getDatabaseName() {
        return this.appConfig.getPropDatabase();
    }
}

