/*
 * Decompiled with CFR 0.152.
 */
package com.parablu;

import com.parablu.config.AppConfig;
import com.parablu.domain.BluVault;
import com.parablu.domain.CollectionDetails;
import com.parablu.domain.Device;
import com.parablu.domain.User;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;

@ComponentScan
public class UpdateUserCollection {
    private static final String DEST_COLLECTION = "destCollection";
    private static final String COLLECTION_NAME = "collectionName";
    private static final String GUEST = "guest";
    private static final String BLUVAULT_NAME = "bluVaultName";
    private static final String DEV_ALLOWED_PER_COLLECTION = "devAllowPerCollection";
    private static long entitiesAllowed = 100L;
    private static ApplicationContext applicationContext;

    public static void main(String[] args) {
        try {
            applicationContext = new AnnotationConfigApplicationContext(UpdateUserCollection.class);
            MongoTemplate mongoTemplate = applicationContext.getBean(MongoTemplate.class);
            AppConfig appConfig = applicationContext.getBean(AppConfig.class);
            BluVault bluVault = mongoTemplate.findOne(new Query(Criteria.where(BLUVAULT_NAME).is(appConfig.getBluvaultName())), BluVault.class);
            if (bluVault != null && bluVault.getComponentsProperties() != null) {
                entitiesAllowed = Long.parseLong(bluVault.getComponentsProperties().get(DEV_ALLOWED_PER_COLLECTION));
            }
            List filteredCollections = mongoTemplate.getCollectionNames().stream().filter(collectionName -> collectionName.matches("BACKUP_\\d+$")).collect(Collectors.toList());
            HashMap<String, Long> deviceData = new HashMap<String, Long>();
            for (String string : filteredCollections) {
                Criteria criteria = new Criteria();
                criteria.andOperator(Criteria.where(DEST_COLLECTION).is(string));
                Query query = new Query(criteria);
                long count = mongoTemplate.count(query, Device.class);
                deviceData.put(string, count);
            }
            for (Map.Entry entry : deviceData.entrySet()) {
                CollectionDetails collectionDetails = mongoTemplate.findOne(new Query(Criteria.where(COLLECTION_NAME).is(entry.getKey())), CollectionDetails.class);
                if (collectionDetails != null) continue;
                collectionDetails = new CollectionDetails();
                collectionDetails.setCollectionName((String)entry.getKey());
                collectionDetails.setEntityCount((Long)entry.getValue());
                mongoTemplate.save(collectionDetails);
            }
            Criteria userCriteria = new Criteria();
            userCriteria.andOperator(Criteria.where(GUEST).is(false));
            Query query = new Query(userCriteria);
            List<User> userList = mongoTemplate.find(query, User.class);
            for (User user : userList) {
                String destinationCollectionName;
                if (user.getSyncDestinationCollection() != null && !user.getSyncDestinationCollection().isEmpty()) continue;
                CollectionDetails collectionDetails = mongoTemplate.findOne(new Query(Criteria.where("entityCount").lt(entitiesAllowed)), CollectionDetails.class);
                if (collectionDetails == null) {
                    long count = mongoTemplate.count(new Query(), CollectionDetails.class);
                    long destinationCollectionCount = count + 2L;
                    destinationCollectionName = "BACKUP_" + destinationCollectionCount;
                    collectionDetails = new CollectionDetails();
                    collectionDetails.setCollectionName(destinationCollectionName);
                    collectionDetails.setEntityCount(1L);
                    mongoTemplate.save(collectionDetails);
                } else {
                    destinationCollectionName = collectionDetails.getCollectionName();
                    collectionDetails.setEntityCount(collectionDetails.getEntityCount() + 1L);
                    mongoTemplate.save(collectionDetails);
                }
                user.setSyncDestinationCollection(destinationCollectionName);
                mongoTemplate.save(user);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

