#!/bin/bash
#Developed By: Vaibhav K
# Script: BACKBLAZE SCRIPT UTILITY

PARABLU_CONFIG_SCRIPT_PATH=/parablu-scripts/Installable/config/parablu_config.sh
PARABLU_COMPONENT_CONFIG_SCRIPT_PATH=/parablu-scripts/Installable/config/parablu_component_config.sh


source $PARABLU_CONFIG_SCRIPT_PATH
source $PARABLU_COMPONENT_CONFIG_SCRIPT_PATH
BACKBLAZE_ID="000b8da189f151b0000000001"
APPLICATION_KEY="K000+opcbeMwqmmpWRDJztjdR6+5CmY"
BACKBLAZE_BUCKET="CUST-Mongodbbackup"

export PATH="/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin:$PATH"

dbport=$(grep port: /etc/mongod.conf)
MONGODB_PORT=$(echo $dbport | sed -e 's/port://' | sed 's/"//g' | tr -d ' ')
date_time="`date '+%Y%m%d'`.zip"
#ssh_key_file="/home/parablugcp/.ssh/devvaibhavmulti"
#ssh-agent
#eval $(ssh-agent)

#ssh-add $ssh_key_file

function get_cust_name ()
{

	CUSTOMER_NAME=$CLOUD_NAME

}

function get_ip_list ()
{

if [ "$SERVER_TYPE" == "3 1" ]; then

echo 'use parablu001
db.PRIVACY_GATEWAY.distinct("gatewayName");' >ipplist.js
else

echo 'use parablu001
db.PRIVACY_GATEWAY.distinct("gatewayName")

db.BLUVAULT.distinct("bluVaultName");' >ipplist.js
fi

        sudo mongo localhost:$MONGODB_PORT -u "neil" -p "parablu" --authenticationDatabase "admin" < ipplist.js >ipplist.log

        grep '"' ipplist.log | sed -e 's/\[//' | sed -e 's/\]//' | sed -e 's/"//g' | sed -e 's/,//g'  >sorted_ipplist.log
	sed -i "/Implicit/d" sorted_iplist.log
        final_iplist=`cat sorted_ipplist.log`
        OTHER_WATCHDOG_IP=$(echo "$final_iplist" | xargs -n1 | sort -u | xargs)

}

function getOtherServerLogs ()
{

get_ip_list
for ping_ip in ${OTHER_WATCHDOG_IP[@]}
        do
		scp -r -P $SSH_PORT ExecuteScriptUtil-$date_time $SSH_USERNAME@$ping_ip:.
		ssh -p $SSH_PORT $SSH_USERNAME@$ping_ip "unzip -o ExecuteScriptUtil-$date_time && bash ExecuteScriptUtil.sh"
		sleep 2s

		ssh -p $SSH_PORT $SSH_USERNAME@$ping_ip "zip -r $ping_ip-utiloutput.zip scriptutil.log"
		sleep 2s

		scp -r -P $SSH_PORT $SSH_USERNAME@$ping_ip:$ping_ip-utiloutput.zip .
		sleep 5s
		ssh -p $SSH_PORT $SSH_USERNAME@$ping_ip "rm -rf $ping_ip-utiloutput.zip ExecuteScriptUtil-$date_time ExecuteScriptUtil.sh scriptutil.log scriptutil.log"
	done

}


###backblaze check

function check_utilscript_backblaze ()
{
	get_cust_name
	backblaze-b2 authorize-account $BACKBLAZE_ID $APPLICATION_KEY
	backblaze-b2 ls $BACKBLAZE_BUCKET $CUSTOMER_NAME | grep -oh ExecuteScriptUtil-$date_time
	if [ $? -eq 0 ]; then
		echo "NEW SCRIPT UTILS FOUND"
		GET_FILE_VERSION=`backblaze-b2 ls --long $BACKBLAZE_BUCKET $CUSTOMER_NAME  | grep ExecuteScriptUtil-$date_time | awk '{print $1}' | head -1`
		echo "FILE VERSION: $GET_FILE_VERSION"
		sleep 1s

		backblaze-b2 download-file-by-name $BACKBLAZE_BUCKET $CUSTOMER_NAME/ExecuteScriptUtil-$date_time ExecuteScriptUtil-$date_time
		if [ $? -eq 0 ]; then
			echo "FILE DOWNLOADED SUCCESSFULLY"

			unzip -o ExecuteScriptUtil-$date_time

			sleep 2s

			bash ExecuteScriptUtil.sh

			sleep 5s
		
			zip -r `hostname`-utiloutput.zip scriptutil.log
			if [ "$SERVER_TYPE" == "3" ] || [ "$SERVER_TYPE" == "3 1" ]; then
				getOtherServerLogs
			fi
		
			sleep 1s

			rm ExecuteScriptUtil-$date_time
			sleep 2s
			zip -r allUtiloutput.zip *.zip
			sleep 2s

			backblaze-b2 upload-file  $BACKBLAZE_BUCKET allUtiloutput.zip $CUSTOMER_NAME/allUtiloutput.zip

			backblaze-b2 delete-file-version $PULLLOGS_CHECK_FILEw $GET_FILE_VERSION

			sleep 4s

			rm -rf *.zip
			rm ExecuteScriptUtil.sh

			rm scriptutil.log
		else
			echo "UNABLE TO DOWNLOAD FILE"
		fi
	else
		echo "NO NEW SCRIPT UTILS FOUND"

	fi

}

if [ "$KEY_BASED_SSH" == "true" ]; then
        ssh-agent
        eval $(ssh-agent)
        ssh-add $SSH_KEY_FILE
fi

check_utilscript_backblaze

if [ "$KEY_BASED_SSH" == "true" ]; then
        killall -9 ssh-agent
fi
