/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.utility.parablu001.o365blacklistuser;

import com.parablu.utility.parablu001.o365blacklistuser.O365BlackListUser;
import com.parablu.utility.parablu001.o365blacklistuser.O365BlackListUserRepository;
import com.parablu.utility.parablu001.o365blacklistuser.O365BlackListUserService;
import com.parablu.utility.parablu001.user.User;
import com.parablu.utility.parablu001.user.UserRepository;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class O365BlackListUserServiceImpl
implements O365BlackListUserService {
    @Autowired
    O365BlackListUserRepository o365blackListUserRepository;
    @Autowired
    UserRepository userRepository;
    private final Logger LOG = LoggerFactory.getLogger(this.getClass());

    public String getAllO365BlackListUsers() {
        StringBuilder builder = new StringBuilder();
        boolean displayData = false;
        builder.append("******************************O365BlackList Users******************************");
        Set all404BlackListUsers = this.o365blackListUserRepository.getAll404BlackListUsers();
        Set all404ActiveBlackListUsers = this.filterByActiveUser(all404BlackListUsers);
        if (!CollectionUtils.isEmpty((Collection)all404ActiveBlackListUsers)) {
            builder.append("\nUsers with 404 :");
            for (O365BlackListUser blackListUser : all404ActiveBlackListUsers) {
                builder.append("\n" + blackListUser.getUserName() + "\n");
                System.out.println("#####$$$$404 users  " + blackListUser.getUserName());
                this.LOG.info("#####$$$$404 users  " + blackListUser.getUserName());
            }
            displayData = true;
        }
        if (!CollectionUtils.isEmpty((Collection)this.o365blackListUserRepository.getAll429BlackListUsers())) {
            Set all429BlackListUsers = this.o365blackListUserRepository.getAll429BlackListUsers();
            Set all429ActiveBlackListUsers = this.filterByActiveUser(all429BlackListUsers);
            builder.append("\nUsers with 429 :");
            for (O365BlackListUser blackListUser : all429ActiveBlackListUsers) {
                builder.append("\n" + blackListUser.getUserName() + "\n");
                System.out.println("#####$$$$429 users  " + blackListUser.getUserName());
                this.LOG.info("#####$$$$429 users  " + blackListUser.getUserName());
            }
            displayData = true;
        }
        if (!CollectionUtils.isEmpty((Collection)this.o365blackListUserRepository.getAll503BlackListUsers())) {
            Set all503BlackListUsers = this.o365blackListUserRepository.getAll503BlackListUsers();
            Set all503ActiveBlackListUsers = this.filterByActiveUser(all503BlackListUsers);
            builder.append("\nUsers with 503 :");
            for (O365BlackListUser blackListUser : all503ActiveBlackListUsers) {
                builder.append("\n" + blackListUser.getUserName() + "\n");
                System.out.println("#####$$$$503 users  " + blackListUser.getUserName());
                this.LOG.info("#####$$$$503 users  " + blackListUser.getUserName());
            }
            displayData = true;
        }
        builder.append("******************************O365BlackList Users******************************");
        if (!displayData) {
            builder = new StringBuilder("");
        }
        return builder.toString();
    }

    private Set<O365BlackListUser> filterByActiveUser(Set<O365BlackListUser> allBlackListUsers) {
        HashSet<O365BlackListUser> all404ActiveBlackListUsers = new HashSet<O365BlackListUser>();
        if (!CollectionUtils.isEmpty(allBlackListUsers)) {
            System.out.println("all404BlackListUsers ..." + allBlackListUsers.size());
            for (O365BlackListUser blackListUser : allBlackListUsers) {
                User user = this.userRepository.findByUserNameLowerCase(blackListUser.getUserName().toLowerCase());
                if (user == null || !user.isActive()) continue;
                all404ActiveBlackListUsers.add(blackListUser);
            }
        }
        return all404ActiveBlackListUsers;
    }
}

