/*
 * Decompiled with CFR 0.152.
 */
package lite;

import com.microsoft.aad.adal4j.AuthenticationContext;
import com.microsoft.aad.adal4j.AuthenticationResult;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;

public class AADTest {
    public static final String AUTHORITY = "https://login.microsoftonline.com/common/";
    public static final String GRAPH_VERSION = "v1.0/";
    public static final String GRAPH_VERSION_BETA = "beta/";
    public static final String GRAPH_ME = "me";
    public static final String GRAPH_HOME = "https://graph.microsoft.com/";
    public static final String GRAPH_MEMBER_OF = "me/memberOf";
    public static final String GRAPH_USER_MEMBER_OF = "/memberOf";
    public static final String GRAPH_USERS = "/users/";
    public static final String GRAPH_GROUP_DELTA = "groups/delta";
    private static final String TOKEN_URL = "https://login.windows.net/";
    private static final String OAUTH2_TOKEN_URL = "/oauth2/token";
    private static final String UTF_8 = "UTF-8";
    private static final String REFRESH_TOKEN = "refresh_token";
    public static final String CONTENT_TYPE = "Content-Type";
    private static final String EXCEPTION = " Exception  :";
    private static final String BACK_UP_ENABLED = "Backup Enabled";
    private static final String SYNC_ENABLED = "Sync Enabled";
    private static final String AUTHORIZATION_CODE = "authorization_code";
    private static final String LOGIN_URL = "https://login.microsoftonline.com/";

    public static void main(String[] args) throws ConfigurationException {
        long l = 1L;
        long k = 2L;
        System.out.println((int)l / (int)k);
        PropertiesConfiguration config = null;
        config = new PropertiesConfiguration(args[0]);
        String userName = config.getProperty("userName").toString();
        String password = config.getProperty("password").toString();
        String clientID = config.getProperty("clientID").toString();
        String proxyHost = config.getProperty("proxyHost").toString();
        int proxyPort = Integer.parseInt(config.getProperty("proxyPort").toString());
        System.out.println("User name : " + userName);
        System.out.println("Password : " + password);
        System.out.println("Client ID : " + clientID);
        System.out.println("Proxy host : " + proxyHost);
        System.out.println("Proxy port : " + proxyPort);
        AADTest.getAccessTokenFromUserCredentials(userName, password, clientID, proxyHost, proxyPort);
    }

    public static Object getAccessTokenFromUserCredentials(String username, String password, String clientID, String proxyHost, int proxyPort) {
        AuthenticationResult result = null;
        ExecutorService service = Executors.newSingleThreadExecutor();
        try {
            Throwable throwable = null;
            Object var9_10 = null;
            try (Closeable close = service::shutdown;){
                AuthenticationContext context = new AuthenticationContext(AUTHORITY, false, service);
                context.setProxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, proxyPort)));
                Future<AuthenticationResult> future = context.acquireToken(GRAPH_HOME, clientID, username, password, null);
                result = future.get();
                System.out.println(result.getAccessToken());
                AADTest.getUserGroupsFromUserToken(result.getAccessToken(), proxyHost, proxyPort);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        return result;
    }

    public static String getUserGroupsFromUserToken(String accessToken, String proxyHost, int proxyPort) {
        StringBuilder response = new StringBuilder();
        try {
            URL url = new URL("https://graph.microsoft.com/v1.0/me/memberOf");
            HttpURLConnection conn = (HttpURLConnection)url.openConnection(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, proxyPort)));
            conn.setRequestMethod("GET");
            conn.setRequestProperty("Authorization", "Bearer " + accessToken);
            conn.setRequestProperty("Accept", "application/json");
            int httpResponseCode = conn.getResponseCode();
            System.out.println("getUserGroupsFromGraph ........response code ......... " + httpResponseCode);
            Throwable throwable = null;
            Object var8_10 = null;
            try (BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));){
                String inputLine;
                while ((inputLine = in.readLine()) != null) {
                    response.append(inputLine);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("getUserGroupsFromGraph ........... body..........." + response.toString());
        return response.toString();
    }
}

