/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal4j;

import com.microsoft.aad.adal4j.AdalAuthorizationGrant;
import com.microsoft.aad.adal4j.AdalCallable;
import com.microsoft.aad.adal4j.AdalDeviceCodeAuthorizationGrant;
import com.microsoft.aad.adal4j.AdalIntegratedAuthorizationGrant;
import com.microsoft.aad.adal4j.AdalOAuthAuthorizationGrant;
import com.microsoft.aad.adal4j.AuthenticationCallback;
import com.microsoft.aad.adal4j.AuthenticationContext;
import com.microsoft.aad.adal4j.AuthenticationException;
import com.microsoft.aad.adal4j.AuthenticationResult;
import com.microsoft.aad.adal4j.ClientDataHttpHeaders;
import com.microsoft.aad.adal4j.LogHelper;
import com.microsoft.aad.adal4j.SAML11BearerGrant;
import com.microsoft.aad.adal4j.StringHelper;
import com.microsoft.aad.adal4j.UserDiscoveryRequest;
import com.microsoft.aad.adal4j.UserDiscoveryResponse;
import com.microsoft.aad.adal4j.WSTrustRequest;
import com.microsoft.aad.adal4j.WSTrustResponse;
import com.nimbusds.jose.util.Base64URL;
import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.ResourceOwnerPasswordCredentialsGrant;
import com.nimbusds.oauth2.sdk.SAML2BearerGrant;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.codec.binary.Base64;

class AcquireTokenCallable
extends AdalCallable<AuthenticationResult> {
    private AdalAuthorizationGrant authGrant;
    private ClientAuthentication clientAuth;

    AcquireTokenCallable(AuthenticationContext context, AdalAuthorizationGrant authGrant, ClientAuthentication clientAuth, AuthenticationCallback<AuthenticationResult> callback) {
        super(context, callback);
        this.authGrant = authGrant;
        this.clientAuth = clientAuth;
        String correlationId = context.correlationId;
        if (StringHelper.isBlank(correlationId) && authGrant instanceof AdalDeviceCodeAuthorizationGrant) {
            correlationId = ((AdalDeviceCodeAuthorizationGrant)authGrant).getCorrelationId();
        }
        this.headers = new ClientDataHttpHeaders(correlationId);
    }

    @Override
    AuthenticationResult execute() throws Exception {
        if (this.authGrant instanceof AdalOAuthAuthorizationGrant) {
            this.authGrant = this.processPasswordGrant((AdalOAuthAuthorizationGrant)this.authGrant);
        }
        if (this.authGrant instanceof AdalIntegratedAuthorizationGrant) {
            AdalIntegratedAuthorizationGrant integratedAuthGrant = (AdalIntegratedAuthorizationGrant)this.authGrant;
            this.authGrant = new AdalOAuthAuthorizationGrant(this.getAuthorizationGrantIntegrated(integratedAuthGrant.getUserName()), integratedAuthGrant.getResource());
        }
        return this.context.acquireTokenCommon(this.authGrant, this.clientAuth, this.headers);
    }

    @Override
    void logResult(AuthenticationResult result, ClientDataHttpHeaders headers) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        if (!StringHelper.isBlank(result.getAccessToken())) {
            String accessTokenHash = this.computeSha256Hash(result.getAccessToken());
            if (!StringHelper.isBlank(result.getRefreshToken())) {
                String refreshTokenHash = this.computeSha256Hash(result.getRefreshToken());
                if (this.context.isLogPii()) {
                    this.context.log.debug(LogHelper.createMessage(String.format("Access Token with hash '%s' and Refresh Token with hash '%s' returned", accessTokenHash, refreshTokenHash), headers.getHeaderCorrelationIdValue()));
                } else {
                    this.context.log.debug(LogHelper.createMessage("Access Token and Refresh Token were returned", headers.getHeaderCorrelationIdValue()));
                }
            } else if (this.context.isLogPii()) {
                this.context.log.debug(LogHelper.createMessage(String.format("Access Token with hash '%s' returned", accessTokenHash), headers.getHeaderCorrelationIdValue()));
            } else {
                this.context.log.debug(LogHelper.createMessage("Access Token was returned", headers.getHeaderCorrelationIdValue()));
            }
        }
    }

    private String computeSha256Hash(String input) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        digest.update(input.getBytes("UTF-8"));
        byte[] hash = digest.digest();
        return Base64.encodeBase64URLSafeString(hash);
    }

    private AdalOAuthAuthorizationGrant processPasswordGrant(AdalOAuthAuthorizationGrant authGrant) throws Exception {
        if (!(authGrant.getAuthorizationGrant() instanceof ResourceOwnerPasswordCredentialsGrant)) {
            return authGrant;
        }
        ResourceOwnerPasswordCredentialsGrant grant = (ResourceOwnerPasswordCredentialsGrant)authGrant.getAuthorizationGrant();
        UserDiscoveryResponse userDiscoveryResponse = UserDiscoveryRequest.execute(this.context.authenticationAuthority.getUserRealmEndpoint(grant.getUsername()), this.headers.getReadonlyHeaderMap(), this.context.proxy, this.context.sslSocketFactory);
        if (userDiscoveryResponse.isAccountFederated()) {
            WSTrustResponse response = WSTrustRequest.execute(userDiscoveryResponse.getFederationMetadataUrl(), grant.getUsername(), grant.getPassword().getValue(), userDiscoveryResponse.getCloudAudienceUrn(), this.context.proxy, this.context.sslSocketFactory, this.context.isLogPii());
            SAML2BearerGrant updatedGrant = null;
            updatedGrant = response.isTokenSaml2() ? new SAML2BearerGrant(new Base64URL(Base64.encodeBase64String(response.getToken().getBytes("UTF-8")))) : new SAML11BearerGrant(new Base64URL(Base64.encodeBase64String(response.getToken().getBytes())));
            authGrant = new AdalOAuthAuthorizationGrant((AuthorizationGrant)updatedGrant, authGrant.getCustomParameters());
        }
        return authGrant;
    }

    AuthorizationGrant getAuthorizationGrantIntegrated(String userName) throws Exception {
        SAML2BearerGrant updatedGrant;
        String userRealmEndpoint = this.context.authenticationAuthority.getUserRealmEndpoint(URLEncoder.encode(userName, "UTF-8"));
        UserDiscoveryResponse userRealmResponse = UserDiscoveryRequest.execute(userRealmEndpoint, this.headers.getReadonlyHeaderMap(), this.context.proxy, this.context.sslSocketFactory);
        if (userRealmResponse.isAccountFederated() && "WSTrust".equalsIgnoreCase(userRealmResponse.getFederationProtocol())) {
            String cloudAudienceUrn;
            String mexURL = userRealmResponse.getFederationMetadataUrl();
            WSTrustResponse wsTrustResponse = WSTrustRequest.execute(mexURL, cloudAudienceUrn = userRealmResponse.getCloudAudienceUrn(), this.context.proxy, this.context.sslSocketFactory, this.context.isLogPii());
            updatedGrant = wsTrustResponse.isTokenSaml2() ? new SAML2BearerGrant(new Base64URL(Base64.encodeBase64String(wsTrustResponse.getToken().getBytes("UTF-8")))) : new SAML11BearerGrant(new Base64URL(Base64.encodeBase64String(wsTrustResponse.getToken().getBytes())));
        } else {
            if (userRealmResponse.isAccountManaged()) {
                throw new AuthenticationException("Password is required for managed user");
            }
            throw new AuthenticationException("Unknown User Type");
        }
        return updatedGrant;
    }
}

