/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.sqs.binders;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMultimap;
import javax.inject.Singleton;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.Binder;

@Singleton
public class BindAttributeNamesToIndexedFormParams
implements Binder {
    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        Iterable values = (Iterable)Iterable.class.cast(Preconditions.checkNotNull(input, "attributeNames"));
        ImmutableMultimap.Builder<String, String> builder = ImmutableMultimap.builder();
        int i = 0;
        for (Object o : values) {
            builder.put("AttributeName." + (i++ + 1), o.toString());
        }
        ImmutableMultimap<String, String> forms = builder.build();
        return (R)(forms.isEmpty() ? request : ((HttpRequest.Builder)((HttpRequest.Builder)request.toBuilder()).replaceFormParams(forms)).build());
    }
}

