/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.clouddns.v1.predicates;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.util.concurrent.Atomics;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.jclouds.rackspace.clouddns.v1.CloudDNSApi;
import org.jclouds.rackspace.clouddns.v1.CloudDNSExceptions;
import org.jclouds.rackspace.clouddns.v1.domain.Job;
import org.jclouds.util.Predicates2;

public class JobPredicates {
    private JobPredicates() {
    }

    public static <T> T awaitComplete(CloudDNSApi api, Job<T> job) throws TimeoutException {
        AtomicReference<Job<T>> jobRef = Atomics.newReference(job);
        if (!Predicates2.retry(JobPredicates.jobCompleted(api), 600L, 2L, 2L, TimeUnit.SECONDS).apply(jobRef)) {
            throw new TimeoutException("Timeout on: " + jobRef.get());
        }
        return jobRef.get().getResource().orNull();
    }

    private static Predicate<AtomicReference<? extends Job<?>>> jobCompleted(CloudDNSApi cloudDNSApi) {
        return new JobStatusPredicate(cloudDNSApi, Job.Status.COMPLETED);
    }

    private static class JobStatusPredicate<T>
    implements Predicate<AtomicReference<Job<?>>> {
        private CloudDNSApi cloudDNSApi;
        private Job.Status status;

        private JobStatusPredicate(CloudDNSApi cloudDNSApi, Job.Status status) {
            this.cloudDNSApi = Preconditions.checkNotNull(cloudDNSApi, "domainApi must be defined");
            this.status = Preconditions.checkNotNull(status, "status must be defined");
        }

        @Override
        public boolean apply(AtomicReference<Job<?>> jobRef) {
            Preconditions.checkNotNull(jobRef, "job must be defined");
            if (this.status.equals((Object)jobRef.get().getStatus())) {
                return true;
            }
            jobRef.set(this.cloudDNSApi.getJob(jobRef.get().getId()));
            Preconditions.checkNotNull(jobRef.get(), "Job %s not found.", jobRef.get().getId());
            if (jobRef.get().getError().isPresent()) {
                throw new CloudDNSExceptions.JobErrorException(jobRef.get().getError().get());
            }
            return this.status.equals((Object)jobRef.get().getStatus());
        }
    }
}

