/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.trove.v1.config;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.inject.Provides;
import java.net.URI;
import javax.inject.Singleton;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.annotation.ClientError;
import org.jclouds.http.annotation.Redirection;
import org.jclouds.http.annotation.ServerError;
import org.jclouds.json.config.GsonModule;
import org.jclouds.openstack.keystone.auth.domain.AuthInfo;
import org.jclouds.openstack.keystone.v2_0.domain.Access;
import org.jclouds.openstack.keystone.v2_0.domain.Tenant;
import org.jclouds.openstack.keystone.v3.domain.Token;
import org.jclouds.openstack.trove.v1.TroveApi;
import org.jclouds.openstack.trove.v1.handlers.TroveErrorHandler;
import org.jclouds.rest.ConfiguresHttpApi;
import org.jclouds.rest.config.HttpApiModule;

@ConfiguresHttpApi
public class TroveHttpApiModule
extends HttpApiModule<TroveApi> {
    @Override
    protected void configure() {
        this.bind(GsonModule.DateAdapter.class).to(GsonModule.Iso8601DateAdapter.class);
        super.configure();
    }

    @Provides
    @Singleton
    public final Multimap<URI, URI> aliases() {
        return ImmutableMultimap.builder().build();
    }

    @Override
    protected void bindErrorHandlers() {
        this.bind(HttpErrorHandler.class).annotatedWith(Redirection.class).to(TroveErrorHandler.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ClientError.class).to(TroveErrorHandler.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ServerError.class).to(TroveErrorHandler.class);
    }

    @Provides
    final Supplier<Optional<String>> supplyTenant(Supplier<AuthInfo> access) {
        return Suppliers.compose(GetTenant.INSTANCE, access);
    }

    private static enum GetTenant implements Function<AuthInfo, Optional<String>>
    {
        INSTANCE;


        @Override
        public Optional<String> apply(AuthInfo in) {
            if (in instanceof Access) {
                return ((Access)Access.class.cast(in)).getToken().getTenant().transform(new Function<Tenant, String>(){

                    @Override
                    public String apply(Tenant input) {
                        return input.getId();
                    }
                });
            }
            if (in instanceof Token) {
                return Optional.of(((Token)Token.class.cast(in)).user().defaultProjectId());
            }
            return Optional.absent();
        }
    }
}

