/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.trove.v1;

import com.google.common.base.Optional;
import com.google.inject.Provides;
import java.io.Closeable;
import java.util.Set;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.jclouds.location.Region;
import org.jclouds.location.functions.RegionToEndpoint;
import org.jclouds.openstack.trove.v1.features.DatabaseApi;
import org.jclouds.openstack.trove.v1.features.FlavorApi;
import org.jclouds.openstack.trove.v1.features.InstanceApi;
import org.jclouds.openstack.trove.v1.features.UserApi;
import org.jclouds.rest.annotations.Delegate;
import org.jclouds.rest.annotations.EndpointParam;

public interface TroveApi
extends Closeable {
    @Provides
    @Region
    public Set<String> getConfiguredRegions();

    @Delegate
    public FlavorApi getFlavorApi(@EndpointParam(parser=RegionToEndpoint.class) String var1);

    @Delegate
    public InstanceApi getInstanceApi(@EndpointParam(parser=RegionToEndpoint.class) String var1);

    @Delegate
    @Path(value="/instances/{instanceId}")
    public UserApi getUserApi(@EndpointParam(parser=RegionToEndpoint.class) String var1, @PathParam(value="instanceId") String var2);

    @Delegate
    @Path(value="/instances/{instanceId}")
    public DatabaseApi getDatabaseApi(@EndpointParam(parser=RegionToEndpoint.class) String var1, @PathParam(value="instanceId") String var2);

    @Deprecated
    @Provides
    @Region
    public Set<String> getConfiguredZones();

    @Deprecated
    @Delegate
    public FlavorApi getFlavorApiForZone(@EndpointParam(parser=RegionToEndpoint.class) String var1);

    @Deprecated
    @Delegate
    public InstanceApi getInstanceApiForZone(@EndpointParam(parser=RegionToEndpoint.class) String var1);

    @Deprecated
    @Delegate
    @Path(value="/instances/{instanceId}")
    public UserApi getUserApiForZoneAndInstance(@EndpointParam(parser=RegionToEndpoint.class) String var1, @PathParam(value="instanceId") String var2);

    @Deprecated
    @Delegate
    @Path(value="/instances/{instanceId}")
    public DatabaseApi getDatabaseApiForZoneAndInstance(@EndpointParam(parser=RegionToEndpoint.class) String var1, @PathParam(value="instanceId") String var2);

    @Provides
    public Optional<String> getCurrentTenantId();
}

