/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.dynect.v3.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import javax.inject.Named;
import org.jclouds.domain.Credentials;

public final class SessionCredentials
extends Credentials {
    @Named(value="customer_name")
    private final String customerName;
    @Named(value="user_name")
    private final String userName;
    private final String password;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return SessionCredentials.builder().from(this);
    }

    @ConstructorProperties(value={"customer_name", "user_name", "password"})
    private SessionCredentials(String customerName, String userName, String password) {
        super(Preconditions.checkNotNull(userName, "userName"), Preconditions.checkNotNull(password, "password for %s", userName));
        this.userName = userName;
        this.password = password;
        this.customerName = Preconditions.checkNotNull(customerName, "customerName for %s", userName);
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public String getCustomerName() {
        return this.customerName;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.customerName, this.userName, this.password);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SessionCredentials other = (SessionCredentials)SessionCredentials.class.cast(obj);
        return Objects.equal(this.userName, other.userName) && Objects.equal(this.password, other.password) && Objects.equal(this.customerName, other.customerName);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).add("userName", this.identity).add("customerName", this.customerName).toString();
    }

    public static final class Builder
    extends Credentials.Builder<SessionCredentials> {
        private String customerName;
        private String userName;
        private String password;

        public Builder customerName(String customerName) {
            this.customerName = customerName;
            return this;
        }

        public Builder identity(String identity) {
            return this.userName(identity);
        }

        public Builder credential(String credential) {
            return this.password(credential);
        }

        public Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        @Override
        public SessionCredentials build() {
            return new SessionCredentials(this.customerName, this.userName, this.password);
        }

        public Builder from(SessionCredentials in) {
            return this.userName(in.identity).password(in.credential).customerName(in.customerName);
        }
    }
}

