/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.config;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.MoreObjects;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.collect.FluentIterable;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.compute.ComputeServiceAdapter;
import org.jclouds.compute.config.BaseComputeServiceContextModule;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.ImageBuilder;
import org.jclouds.compute.strategy.CreateNodeWithGroupEncodedIntoName;
import org.jclouds.compute.strategy.DestroyNodeStrategy;
import org.jclouds.compute.strategy.GetImageStrategy;
import org.jclouds.compute.strategy.GetNodeMetadataStrategy;
import org.jclouds.compute.strategy.ListNodesStrategy;
import org.jclouds.compute.strategy.PopulateDefaultLoginCredentialsForImageStrategy;
import org.jclouds.compute.strategy.RebootNodeStrategy;
import org.jclouds.compute.strategy.ResumeNodeStrategy;
import org.jclouds.compute.strategy.SuspendNodeStrategy;
import org.jclouds.compute.strategy.impl.AdaptingComputeServiceStrategies;
import org.jclouds.domain.Location;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.location.suppliers.LocationsSupplier;

public class ComputeServiceAdapterContextModule<N, H, I, L>
extends BaseComputeServiceContextModule {
    @Provides
    @Singleton
    protected final Supplier<Set<? extends Hardware>> provideHardware(final ComputeServiceAdapter<N, H, I, L> adapter, final Function<H, Hardware> transformer) {
        return new Supplier<Set<? extends Hardware>>(){

            @Override
            public Set<? extends Hardware> get() {
                return ComputeServiceAdapterContextModule.transformGuardingNull(adapter.listHardwareProfiles(), transformer);
            }

            public String toString() {
                return MoreObjects.toStringHelper(adapter).add("method", "listHardwareProfiles").toString();
            }
        };
    }

    private static <F, T> Set<? extends T> transformGuardingNull(Iterable<F> from, Function<F, T> transformer) {
        return FluentIterable.from(from).filter(Predicates.notNull()).transform(transformer).filter(Predicates.notNull()).toSet();
    }

    @Provides
    @Singleton
    protected final Supplier<Set<? extends Image>> provideImages(final ComputeServiceAdapter<N, H, I, L> adapter, final Function<I, Image> transformer, final AddDefaultCredentialsToImage addDefaultCredentialsToImage) {
        return new Supplier<Set<? extends Image>>(){

            @Override
            public Set<? extends Image> get() {
                return ComputeServiceAdapterContextModule.transformGuardingNull(adapter.listImages(), Functions.compose(addDefaultCredentialsToImage, transformer));
            }

            public String toString() {
                return MoreObjects.toStringHelper(adapter).add("method", "listImages").toString();
            }
        };
    }

    @Provides
    @Singleton
    protected final CreateNodeWithGroupEncodedIntoName defineAddNodeWithTagStrategy(AdaptingComputeServiceStrategies<N, H, I, L> in) {
        return in;
    }

    @Provides
    @Singleton
    protected final DestroyNodeStrategy defineDestroyNodeStrategy(AdaptingComputeServiceStrategies<N, H, I, L> in) {
        return in;
    }

    @Provides
    @Singleton
    protected final GetNodeMetadataStrategy defineGetNodeMetadataStrategy(AdaptingComputeServiceStrategies<N, H, I, L> in) {
        return in;
    }

    @Provides
    @Singleton
    protected final GetImageStrategy defineGetImageStrategy(AdaptingComputeServiceStrategies<N, H, I, L> in) {
        return in;
    }

    @Provides
    @Singleton
    protected final ListNodesStrategy defineListNodesStrategy(AdaptingComputeServiceStrategies<N, H, I, L> in) {
        return in;
    }

    @Provides
    @Singleton
    protected final RebootNodeStrategy defineRebootNodeStrategy(AdaptingComputeServiceStrategies<N, H, I, L> in) {
        return in;
    }

    @Provides
    @Singleton
    protected final ResumeNodeStrategy defineStartNodeStrategy(AdaptingComputeServiceStrategies<N, H, I, L> in) {
        return in;
    }

    @Provides
    @Singleton
    protected final SuspendNodeStrategy defineStopNodeStrategy(AdaptingComputeServiceStrategies<N, H, I, L> in) {
        return in;
    }

    @Singleton
    public static class AddDefaultCredentialsToImage
    implements Function<Image, Image> {
        private final PopulateDefaultLoginCredentialsForImageStrategy credsForImage;

        @Inject
        public AddDefaultCredentialsToImage(PopulateDefaultLoginCredentialsForImageStrategy credsForImage) {
            this.credsForImage = credsForImage;
        }

        @Override
        public Image apply(Image arg0) {
            if (arg0 == null) {
                return null;
            }
            LoginCredentials credentials = this.credsForImage.apply(arg0);
            return credentials != null ? ImageBuilder.fromImage(arg0).defaultCredentials(credentials).build() : arg0;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("credsForImage", this.credsForImage).toString();
        }
    }

    public static class LocationsFromComputeServiceAdapterModule<N, H, I, L>
    extends AbstractModule {
        @Override
        protected void configure() {
        }

        @Provides
        @Singleton
        protected final LocationsSupplier supplyLocationsFromComputeServiceAdapter(final ComputeServiceAdapter<N, H, I, L> adapter, final Function<L, Location> transformer) {
            return new LocationsSupplier(){

                @Override
                public Set<? extends Location> get() {
                    return ComputeServiceAdapterContextModule.transformGuardingNull(adapter.listLocations(), transformer);
                }

                public String toString() {
                    return MoreObjects.toStringHelper(adapter).add("method", "listLocations").toString();
                }
            };
        }
    }
}

