/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.options;

import com.google.common.collect.ImmutableSet;
import java.util.Map;
import org.jclouds.cloudstack.domain.Snapshot;
import org.jclouds.cloudstack.options.AccountInDomainOptions;

public class ListSnapshotsOptions
extends AccountInDomainOptions {
    public static final ListSnapshotsOptions NONE = new ListSnapshotsOptions();

    public ListSnapshotsOptions id(String id) {
        this.queryParameters.replaceValues("id", ImmutableSet.of(id + ""));
        return this;
    }

    public ListSnapshotsOptions interval(Snapshot.Interval interval) {
        this.queryParameters.replaceValues("intervaltype", ImmutableSet.of((Object)((Object)interval) + ""));
        return this;
    }

    public ListSnapshotsOptions isRecursive(boolean isRecursive) {
        this.queryParameters.replaceValues("isrecursive", ImmutableSet.of(isRecursive + ""));
        return this;
    }

    public ListSnapshotsOptions keyword(String keyword) {
        this.queryParameters.replaceValues("keyword", ImmutableSet.of(keyword + ""));
        return this;
    }

    public ListSnapshotsOptions name(String name) {
        this.queryParameters.replaceValues("name", ImmutableSet.of(name + ""));
        return this;
    }

    public ListSnapshotsOptions snapshotType(Snapshot.Type snapshotType) {
        this.queryParameters.replaceValues("snapshottype", ImmutableSet.of((Object)((Object)snapshotType) + ""));
        return this;
    }

    public ListSnapshotsOptions volumeId(String volumeId) {
        this.queryParameters.replaceValues("volumeid", ImmutableSet.of(volumeId + ""));
        return this;
    }

    public ListSnapshotsOptions projectId(String projectId) {
        this.queryParameters.replaceValues("projectid", ImmutableSet.of(projectId + ""));
        return this;
    }

    public ListSnapshotsOptions tags(Map<String, String> tags) {
        int count = 0;
        for (Map.Entry<String, String> entry : tags.entrySet()) {
            this.queryParameters.replaceValues(String.format("tags[%d].key", count), ImmutableSet.of(entry.getKey()));
            this.queryParameters.replaceValues(String.format("tags[%d].value", count), ImmutableSet.of(entry.getValue()));
            ++count;
        }
        return this;
    }

    public static class Builder {
        public static ListSnapshotsOptions accountInDomain(String account, String domainId) {
            return (ListSnapshotsOptions)new ListSnapshotsOptions().accountInDomain(account, domainId);
        }

        public static ListSnapshotsOptions domainId(String domainId) {
            return (ListSnapshotsOptions)new ListSnapshotsOptions().domainId(domainId);
        }

        public static ListSnapshotsOptions id(String id) {
            return new ListSnapshotsOptions().id(id);
        }

        public static ListSnapshotsOptions interval(Snapshot.Interval interval) {
            return new ListSnapshotsOptions().interval(interval);
        }

        public static ListSnapshotsOptions isRecursive(boolean isRecursive) {
            return new ListSnapshotsOptions().isRecursive(isRecursive);
        }

        public static ListSnapshotsOptions keyword(String keyword) {
            return new ListSnapshotsOptions().keyword(keyword);
        }

        public static ListSnapshotsOptions name(String name) {
            return new ListSnapshotsOptions().name(name);
        }

        public static ListSnapshotsOptions snapshotType(Snapshot.Type snapshotType) {
            return new ListSnapshotsOptions().snapshotType(snapshotType);
        }

        public static ListSnapshotsOptions volumeId(String volumeId) {
            return new ListSnapshotsOptions().volumeId(volumeId);
        }

        public static ListSnapshotsOptions projectId(String projectId) {
            return new ListSnapshotsOptions().projectId(projectId);
        }

        public static ListSnapshotsOptions tags(Map<String, String> tags) {
            return new ListSnapshotsOptions().tags(tags);
        }
    }
}

