/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.domain;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.jclouds.azurecompute.arm.domain.AutoValue_Key;
import org.jclouds.azurecompute.arm.domain.AutoValue_Key_DeletedKeyBundle;
import org.jclouds.azurecompute.arm.domain.AutoValue_Key_JsonWebKey;
import org.jclouds.azurecompute.arm.domain.AutoValue_Key_KeyAttributes;
import org.jclouds.azurecompute.arm.domain.AutoValue_Key_KeyBundle;
import org.jclouds.azurecompute.arm.domain.AutoValue_Key_KeyOperationResult;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.SerializedNames;

public abstract class Key {
    @Nullable
    public abstract String kid();

    public abstract KeyAttributes attributes();

    @Nullable
    public abstract Boolean managed();

    @Nullable
    public abstract Map<String, String> tags();

    @SerializedNames(value={"kid", "attributes", "managed", "tags"})
    public static Key create(String kid, KeyAttributes attributes, boolean managed, Map<String, String> tags) {
        return new AutoValue_Key(kid, attributes, managed, tags != null ? ImmutableMap.copyOf(tags) : null);
    }

    Key() {
    }

    public static abstract class KeyOperationResult {
        @Nullable
        public abstract String keyId();

        @Nullable
        public abstract String value();

        @SerializedNames(value={"kid", "value"})
        public static KeyOperationResult create(String keyId, String value) {
            return new AutoValue_Key_KeyOperationResult(keyId, value);
        }
    }

    public static abstract class DeletedKeyBundle {
        @Nullable
        public abstract KeyAttributes attributes();

        @Nullable
        public abstract String deletedDate();

        @Nullable
        public abstract JsonWebKey key();

        @Nullable
        public abstract Boolean managed();

        @Nullable
        public abstract String recoveryId();

        @Nullable
        public abstract String scheduledPurgeDate();

        @Nullable
        public abstract Map<String, String> tags();

        @SerializedNames(value={"attributes", "deletedDate", "key", "managed", "recoveryId", "scheduledPurgeDate", "tags"})
        public static DeletedKeyBundle create(KeyAttributes attributes, String deletedDate, JsonWebKey key, boolean managed, String recoveryId, String scheduledPurgeDate, Map<String, String> tags) {
            return new AutoValue_Key_DeletedKeyBundle(attributes, deletedDate, key, managed, recoveryId, scheduledPurgeDate, tags != null ? ImmutableMap.copyOf(tags) : null);
        }
    }

    public static abstract class KeyBundle {
        @Nullable
        public abstract KeyAttributes attributes();

        @Nullable
        public abstract JsonWebKey key();

        @Nullable
        public abstract Boolean managed();

        @Nullable
        public abstract Map<String, String> tags();

        @SerializedNames(value={"attributes", "key", "managed", "tags"})
        public static KeyBundle create(KeyAttributes attributes, JsonWebKey key, boolean managed, Map<String, String> tags) {
            return new AutoValue_Key_KeyBundle(attributes, key, managed, tags != null ? ImmutableMap.copyOf(tags) : null);
        }
    }

    public static abstract class KeyAttributes {
        @Nullable
        public abstract Boolean enabled();

        @Nullable
        public abstract Integer created();

        @Nullable
        public abstract Integer expires();

        @Nullable
        public abstract Integer notBefore();

        @Nullable
        public abstract String recoveryLevel();

        @Nullable
        public abstract Integer updated();

        @SerializedNames(value={"enabled", "created", "expires", "notBefore", "recoveryLevel", "updated"})
        public static KeyAttributes create(Boolean enabled, Integer created, Integer expires, Integer notBefore, String recoveryLevel, Integer updated) {
            return new AutoValue_Key_KeyAttributes(enabled, created, expires, notBefore, recoveryLevel, updated);
        }

        KeyAttributes() {
        }
    }

    public static abstract class JsonWebKey {
        @Nullable
        public abstract String crv();

        @Nullable
        public abstract String d();

        @Nullable
        public abstract String dp();

        @Nullable
        public abstract String dq();

        @Nullable
        public abstract String e();

        @Nullable
        public abstract String k();

        @Nullable
        public abstract String keyHsm();

        public abstract List<String> keyOps();

        @Nullable
        public abstract String kid();

        @Nullable
        public abstract String kty();

        @Nullable
        public abstract String n();

        @Nullable
        public abstract String p();

        @Nullable
        public abstract String q();

        @Nullable
        public abstract String qi();

        @Nullable
        public abstract String x();

        @Nullable
        public abstract String y();

        @SerializedNames(value={"crv", "d", "dp", "dq", "e", "k", "key_hsm", "key_ops", "kid", "kty", "n", "p", "q", "qi", "x", "y"})
        public static JsonWebKey create(String crv, String d, String dp, String dq, String e, String k, String keyHsm, List<String> keyOps, String kid, String kty, String n, String p, String q, String qi, String x, String y) {
            return new AutoValue_Key_JsonWebKey(crv, d, dp, dq, e, k, keyHsm, keyOps != null ? ImmutableList.copyOf(keyOps) : ImmutableList.of(), kid, kty, n, p, q, qi, x, y);
        }
    }
}

