/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import org.jclouds.azurecompute.arm.domain.Plan;
import org.jclouds.azurecompute.arm.domain.VMImage;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.ImageBuilder;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.domain.Location;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.location.predicates.LocationPredicates;

public class VMImageToImage
implements Function<VMImage, Image> {
    private static final Map<String, OsFamily> OTHER_OS_MAP = ImmutableMap.builder().put("openlogic", OsFamily.CENTOS).put("win", OsFamily.WINDOWS).put("sles", OsFamily.SUSE).put("oracle-linux", OsFamily.OEL).build();
    private final Supplier<Set<? extends Location>> locations;

    @Inject
    VMImageToImage(@Memoized Supplier<Set<? extends Location>> locations) {
        this.locations = locations;
    }

    @Override
    public Image apply(VMImage image) {
        ImageBuilder builder = new ImageBuilder();
        VMImageToImage.addMarketplacePlanToMetadataIfPresent(builder, image);
        Location location = FluentIterable.from(this.locations.get()).firstMatch(LocationPredicates.idEquals(image.location())).get();
        if (image.custom()) {
            builder.id(image.encodeFieldsToUniqueIdCustom()).providerId(image.customImageId()).name(image.name()).location(location).description(image.group()).status(Image.Status.AVAILABLE).version("latest");
        } else {
            builder.id(image.encodeFieldsToUniqueId()).providerId(image.publisher()).name(image.offer()).location(location).description(image.sku()).status(Image.Status.AVAILABLE).version(image.sku());
        }
        OperatingSystem.Builder osBuilder = VMImageToImage.osFamily().apply(image);
        builder.operatingSystem(osBuilder.build());
        return builder.build();
    }

    private static void addMarketplacePlanToMetadataIfPresent(ImageBuilder builder, VMImage image) {
        if (image.versionProperties() != null && image.versionProperties().plan() != null) {
            Plan plan = image.versionProperties().plan();
            builder.userMetadata(ImmutableMap.of("publisher", plan.publisher(), "name", plan.name(), "product", plan.product()));
        }
    }

    @Nullable
    public static Plan getMarketplacePlanFromImageMetadata(Image image) {
        Map<String, String> imageMetadata = image.getUserMetadata();
        return imageMetadata.containsKey("product") ? Plan.create(imageMetadata.get("publisher"), imageMetadata.get("name"), imageMetadata.get("product")) : null;
    }

    public static Function<VMImage, OperatingSystem.Builder> osFamily() {
        return new Function<VMImage, OperatingSystem.Builder>(){

            @Override
            public OperatingSystem.Builder apply(VMImage image) {
                String label = Preconditions.checkNotNull(image.offer(), "offer").toLowerCase();
                OsFamily family = VMImageToImage.findInStandardFamilies(label).or(VMImageToImage.findInOtherOSMap(label)).or(OsFamily.UNRECOGNIZED);
                if (OsFamily.UNRECOGNIZED == family && image.versionProperties() != null && image.versionProperties().osDiskImage() != null && image.versionProperties().osDiskImage().operatingSystem() != null) {
                    family = OsFamily.fromValue(image.versionProperties().osDiskImage().operatingSystem().toUpperCase());
                }
                return OperatingSystem.builder().family(family).is64Bit(true).description(image.custom() ? "custom" : image.sku()).version(image.custom() ? "latest" : image.sku());
            }
        };
    }

    private static Optional<OsFamily> findInStandardFamilies(final String label) {
        return Iterables.tryFind(Arrays.asList(OsFamily.values()), new Predicate<OsFamily>(){

            @Override
            public boolean apply(OsFamily input) {
                return label.contains(input.value());
            }
        });
    }

    private static Optional<OsFamily> findInOtherOSMap(final String label) {
        return Iterables.tryFind(OTHER_OS_MAP.keySet(), new Predicate<String>(){

            @Override
            public boolean apply(String input) {
                return label.contains(input);
            }
        }).transform(new Function<String, OsFamily>(){

            @Override
            public OsFamily apply(String input) {
                return (OsFamily)((Object)OTHER_OS_MAP.get(input));
            }
        });
    }
}

