/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.client;

import com.backblaze.b2.client.B2LargeFileStorer;
import com.backblaze.b2.client.B2PartStorer;
import com.backblaze.b2.client.structures.B2Part;
import com.backblaze.b2.client.structures.B2UploadListener;
import com.backblaze.b2.client.structures.B2UploadState;
import java.util.Objects;

public class B2AlreadyStoredPartStorer
implements B2PartStorer {
    private final B2Part part;

    public B2AlreadyStoredPartStorer(B2Part part) {
        this.part = part;
    }

    @Override
    public long getPartSizeOrThrow() {
        return this.part.getContentLength();
    }

    @Override
    public int getPartNumber() {
        return this.part.getPartNumber();
    }

    @Override
    public B2Part storePart(B2LargeFileStorer largeFileCreationManager, B2UploadListener uploadListener) {
        largeFileCreationManager.updateProgress(uploadListener, this.part.getPartNumber(), this.part.getContentLength(), this.part.getContentLength(), B2UploadState.SUCCEEDED);
        return this.part;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        B2AlreadyStoredPartStorer that = (B2AlreadyStoredPartStorer)o;
        return Objects.equals(this.part, that.part);
    }

    public int hashCode() {
        return Objects.hash(this.part);
    }
}

