/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.json;

import com.backblaze.b2.json.B2JsonOptions;
import com.backblaze.b2.util.B2Utf8Util;
import java.io.IOException;
import java.io.OutputStream;

public class B2JsonWriter {
    private final OutputStream out;
    private int indentLevel = 0;
    private boolean objectOrArrayEmpty = true;
    private boolean allowNewlines = true;
    private final B2JsonOptions.SerializationOption serializationOption;

    public B2JsonWriter(OutputStream out, B2JsonOptions options) {
        this.out = out;
        this.serializationOption = options.getSerializationOption();
    }

    public void writeText(String text) throws IOException {
        B2Utf8Util.write(text, this.out);
        this.objectOrArrayEmpty = false;
    }

    public void setAllowNewlines(boolean allowNewlines) {
        this.allowNewlines = allowNewlines;
    }

    public void startObject() throws IOException {
        this.out.write(123);
        ++this.indentLevel;
        this.objectOrArrayEmpty = true;
    }

    public void writeObjectFieldNameAndColon(String name) throws IOException {
        this.startObjectFieldName();
        this.writeString(name);
        this.writeFieldNameValueSeparator();
    }

    public void writeFieldNameValueSeparator() throws IOException {
        this.out.write(58);
        if (this.serializationOption != B2JsonOptions.SerializationOption.COMPACT) {
            this.out.write(32);
        }
    }

    public void startObjectFieldName() throws IOException {
        if (!this.objectOrArrayEmpty) {
            this.out.write(44);
        }
        this.newlineAndIndent();
    }

    public void finishObject() throws IOException {
        --this.indentLevel;
        if (!this.objectOrArrayEmpty) {
            this.newlineAndIndent();
        }
        this.out.write(125);
        this.objectOrArrayEmpty = false;
    }

    public void startArray() throws IOException {
        this.out.write(91);
        ++this.indentLevel;
        this.objectOrArrayEmpty = true;
    }

    public void startArrayValue() throws IOException {
        this.startObjectFieldName();
    }

    public void finishArray() throws IOException {
        --this.indentLevel;
        if (!this.objectOrArrayEmpty) {
            this.newlineAndIndent();
        }
        this.out.write(93);
        this.objectOrArrayEmpty = false;
    }

    public void writeString(CharSequence value) throws IOException {
        B2Utf8Util.writeJsonString(value, this.out);
        this.objectOrArrayEmpty = false;
    }

    private void newlineAndIndent() throws IOException {
        if (this.serializationOption == B2JsonOptions.SerializationOption.COMPACT) {
            return;
        }
        if (this.allowNewlines) {
            this.out.write(10);
            for (int i = 0; i < this.indentLevel; ++i) {
                this.out.write(32);
                this.out.write(32);
            }
        } else {
            this.out.write(32);
        }
    }
}

