/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.json;

import com.backblaze.b2.json.B2JsonBadValueException;
import com.backblaze.b2.json.B2JsonException;
import com.backblaze.b2.json.B2JsonNonUrlTypeHandler;
import com.backblaze.b2.json.B2JsonOptions;
import com.backblaze.b2.json.B2JsonReader;
import com.backblaze.b2.json.B2JsonTypeHandler;
import com.backblaze.b2.json.B2JsonUtil;
import com.backblaze.b2.json.B2JsonWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;

public class B2JsonByteArrayHandler
extends B2JsonNonUrlTypeHandler<byte[]> {
    private final B2JsonTypeHandler itemHandler;

    public B2JsonByteArrayHandler(B2JsonTypeHandler itemHandler) {
        this.itemHandler = itemHandler;
    }

    @Override
    public Type getHandledType() {
        return byte[].class;
    }

    @Override
    public void serialize(byte[] array, B2JsonOptions options, B2JsonWriter out) throws IOException, B2JsonException {
        out.setAllowNewlines(false);
        out.startArray();
        byte[] byArray = array;
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            Byte item = byArray[i];
            out.startArrayValue();
            B2JsonUtil.serializeMaybeNull(this.itemHandler, item, out, options);
        }
        out.finishArray();
        out.setAllowNewlines(true);
    }

    @Override
    public byte[] deserialize(B2JsonReader in, B2JsonOptions options) throws B2JsonException, IOException {
        ArrayList<Byte> result = new ArrayList<Byte>();
        if (in.startArrayAndCheckForContents()) {
            do {
                result.add((Byte)B2JsonUtil.deserializeMaybeNull(this.itemHandler, in, options));
            } while (in.arrayHasMoreValues());
        }
        in.finishArray();
        int nElts = result.size();
        byte[] array = new byte[nElts];
        int i = 0;
        for (Byte elt : result) {
            if (elt == null) {
                throw new B2JsonBadValueException("can't put null in a byte[].");
            }
            array[i] = elt;
            ++i;
        }
        return array;
    }

    @Override
    public byte[] defaultValueForOptional() {
        return null;
    }

    @Override
    public boolean isStringInJson() {
        return false;
    }
}

