/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.client.structures;

import com.backblaze.b2.json.B2Json;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;

public class B2ApplicationKey {
    @B2Json.required
    private final String accountId;
    @B2Json.required
    private final String applicationKeyId;
    @B2Json.required
    private final String keyName;
    @B2Json.required
    private final TreeSet<String> capabilities;
    @B2Json.optional
    private final String bucketId;
    @B2Json.optional
    private final String namePrefix;
    @B2Json.optional
    private final Long expirationTimestamp;
    @B2Json.optional
    private final Set<String> options;

    @B2Json.constructor(params="accountId, applicationKeyId, keyName, capabilities, bucketId, namePrefix, expirationTimestamp, options")
    public B2ApplicationKey(String accountId, String applicationKeyId, String keyName, TreeSet<String> capabilities, String bucketId, String namePrefix, Long expirationTimestamp, Set<String> options) {
        this.accountId = accountId;
        this.applicationKeyId = applicationKeyId;
        this.keyName = keyName;
        this.capabilities = capabilities;
        this.bucketId = bucketId;
        this.namePrefix = namePrefix;
        this.expirationTimestamp = expirationTimestamp;
        this.options = options;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public String getApplicationKeyId() {
        return this.applicationKeyId;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public TreeSet<String> getCapabilities() {
        return this.capabilities;
    }

    public String getBucketId() {
        return this.bucketId;
    }

    public String getNamePrefix() {
        return this.namePrefix;
    }

    public Long getExpirationTimestamp() {
        return this.expirationTimestamp;
    }

    public Set<String> getOptions() {
        return this.options;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        B2ApplicationKey that = (B2ApplicationKey)o;
        return Objects.equals(this.accountId, that.accountId) && Objects.equals(this.applicationKeyId, that.applicationKeyId) && Objects.equals(this.keyName, that.keyName) && Objects.equals(this.capabilities, that.capabilities) && Objects.equals(this.bucketId, that.bucketId) && Objects.equals(this.namePrefix, that.namePrefix) && Objects.equals(this.expirationTimestamp, that.expirationTimestamp) && Objects.equals(this.options, that.options);
    }

    public int hashCode() {
        return Objects.hash(this.accountId, this.applicationKeyId, this.keyName, this.capabilities, this.bucketId, this.namePrefix, this.expirationTimestamp, this.options);
    }
}

