/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.component.composition;

import java.util.Iterator;
import java.util.List;
import org.codehaus.plexus.component.composition.CompositionException;
import org.codehaus.plexus.component.composition.CompositionResolver;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.component.repository.ComponentRequirement;
import org.codehaus.plexus.util.dag.CycleDetectedException;
import org.codehaus.plexus.util.dag.DAG;

public class DefaultCompositionResolver
implements CompositionResolver {
    private DAG dag = new DAG();

    public void addComponentDescriptor(ComponentDescriptor componentDescriptor) throws CompositionException {
        String key = this.getDAGKey(componentDescriptor.getRole(), componentDescriptor.getRoleHint());
        List<ComponentRequirement> requirements = componentDescriptor.getRequirements();
        Iterator<ComponentRequirement> iterator = requirements.iterator();
        while (iterator.hasNext()) {
            ComponentRequirement requirement = iterator.next();
            try {
                this.dag.addEdge(key, this.getDAGKey(requirement.getRole(), requirement.getRoleHint()));
            }
            catch (CycleDetectedException e) {
                throw new CompositionException("Cyclic requirement detected", e);
            }
        }
    }

    public List getRequirements(String role, String roleHint) {
        return this.dag.getChildLabels(this.getDAGKey(role, roleHint));
    }

    public List findRequirements(String role, String roleHint) {
        return this.dag.getParentLabels(this.getDAGKey(role, roleHint));
    }

    private String getDAGKey(String role, String roleHint) {
        return role + ':' + roleHint;
    }
}

