/*
 * Decompiled with CFR 0.152.
 */
package Utility.com.parablu;

import Utility.com.parablu.WeeklyMailChanges;
import com.mongodb.BasicDBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.parablu.pcbd.domain.BackupAttempt;
import com.parablu.pcbd.domain.BackupHistoryElement;
import com.parablu.pcbd.domain.Device;
import com.parablu.pcbd.domain.DeviceBackupOverView;
import com.parablu.pcbd.domain.EmailProps;
import java.io.FileWriter;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.bson.Document;
import org.springframework.util.CollectionUtils;

public class WeeklyMailChangesNew {
    private static final String MM_DD_YYYY = "MM/dd/yyyy";
    private static final String INSIDE_SEND_CLOUD_OVER_VIEW_JOB_TIMER = " @@@@@@@@@@@@@@@@@@@@@@@@@@ inside send cloud over view job timer ";
    private static final String BEFORE_SENDING_MAIL = " @@@ Before sending mail ";
    private static final String NO_ATTEMPT = "No Attempt";
    private static final String NILL = " ";
    private static final String PARSE_EXCEPTION = "ParseException  ";
    private static final String INVALID_DAY_VALUE = "Invalid Day value";
    private static final String NUMBER_FORMAT_EXCEPTION = "NumberFormatException  ";
    private static final String MM_DD_YYYY_HH_MM_SS = "MM/dd/yyyy HH:mm:ss";

    public static void main(String[] args) throws Exception {
        MongoClientURI uri = new MongoClientURI("mongodb://neil:parablu@karthickcloud.parablu.com:48765/parablu001");
        MongoClient client = new MongoClient(uri);
        MongoDatabase db = client.getDatabase(uri.getDatabase());
        MongoCollection<Document> batchDBCollection = db.getCollection("BACKUP_ATTEMPT");
        MongoCollection<Document> attemptsDBCollection = db.getCollection("BACKUP_ATTEMPT");
        MongoCollection<Document> devicebkpCol = db.getCollection("DEVICE_BACKUP_OVERVIEW");
        MongoCollection<Document> deviceColl = db.getCollection("DEVICE");
        BasicDBObject andQuery = new BasicDBObject();
        andQuery = new BasicDBObject();
        ArrayList<BasicDBObject> whereQuery = new ArrayList<BasicDBObject>();
        whereQuery = new ArrayList();
        whereQuery.add(new BasicDBObject("userName", "pari2"));
        andQuery.put("$and", whereQuery);
        FindIterable<Document> batchList = batchDBCollection.find(andQuery);
        Document deviceBkpOverview = (Document)devicebkpCol.find(new BasicDBObject("userName", "pari2")).first();
        Document device = (Document)deviceColl.find(new BasicDBObject("userName", "pari2")).first();
        System.out.println(devicebkpCol.count());
        ArrayList<BackupHistoryElement> backupHistoryElements = new ArrayList<BackupHistoryElement>();
        for (Document document : batchList) {
            BackupHistoryElement backupHistoryElement = new BackupHistoryElement();
            backupHistoryElement.setBatchId(document.getObjectId("_id").toString());
            backupHistoryElement.setDeviceName("bat");
            backupHistoryElement.setUserName("batUserName");
            backupHistoryElement.setPolicyName("policyName");
            backupHistoryElement.setStartTime(WeeklyMailChangesNew.getDate(document.getLong("batchStartTimestamp")));
            backupHistoryElement.setEndTime(WeeklyMailChangesNew.getDate(document.getLong("batchEndTimestamp")));
            backupHistoryElement.setUploadedSize(document.getString("uploadedSize"));
            backupHistoryElement.setAction(WeeklyMailChangesNew.getCommentsForBackupBatch(document.getString("errorCode")));
            String uploadedFiles = document.getString("uploadedFiles");
            String[] parts = uploadedFiles.split("/");
            try {
                backupHistoryElement.setNoOfFiles(Integer.parseInt(parts[0]));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ArrayList<BackupAttempt> attempts = new ArrayList<BackupAttempt>();
            batchList = attemptsDBCollection.find(new BasicDBObject("batchId", document.getObjectId("_id").toString()));
            for (Document attempt : batchList) {
                BackupAttempt readValue = new BackupAttempt();
                readValue.setBatchEndTimestamp(attempt.getLong("batchStartTimestamp"));
                readValue.setBatchEndTimestamp(attempt.getLong("batchEndTimestamp"));
                readValue.setUploadedSize(attempt.getString("uploadedSize"));
                readValue.setTotalNoOfFiles(attempt.getLong("totalNoOfFiles"));
                readValue.setStatus(attempt.getString("status"));
                readValue.setErrorCode(attempt.getString("errorCode"));
                attempts.add(readValue);
            }
            backupHistoryElement.setStatus(document.getString("status"));
            backupHistoryElement.setBackupAttempts(attempts);
            backupHistoryElements.add(backupHistoryElement);
        }
        StringBuilder bodyData = new StringBuilder();
        EmailProps tempEmail = new EmailProps();
        WeeklyMailChangesNew.setDaysElementForSendmail(tempEmail);
        String prviousState = "";
        int i = 0;
        while (i < 7) {
            String dateToCheck = WeeklyMailChangesNew.getDateForApproprioteDay(i);
            backupHistoryElements.sort(Comparator.comparing(BackupHistoryElement::getEndTime));
            WeeklyMailChangesNew.setDate(tempEmail, WeeklyMailChangesNew.getDayOfTheWeek(dateToCheck), dateToCheck);
            for (BackupHistoryElement backupHistoryElement : backupHistoryElements) {
                if (backupHistoryElement == null || backupHistoryElement.getStatus().equalsIgnoreCase("SCANNING")) continue;
                if (dateToCheck.equals(WeeklyMailChangesNew.getDay(backupHistoryElement.getEndTime()))) {
                    int dayVal = WeeklyMailChangesNew.getDayOfTheWeek(WeeklyMailChangesNew.getDay(backupHistoryElement.getEndTime()));
                    if (WeeklyMailChangesNew.isBackupStartedinWindowPeriod(WeeklyMailChangesNew.getDay(backupHistoryElement.getStartTime()))) {
                        int startDayVal = WeeklyMailChangesNew.getDayOfTheWeek(WeeklyMailChangesNew.getDay(backupHistoryElement.getStartTime()));
                        if (prviousState.equalsIgnoreCase("Successfully Completed") || StringUtils.isEmpty(prviousState)) {
                            WeeklyMailChangesNew.setBackupStatusForDay(tempEmail, startDayVal, WeeklyMailChangesNew.getStatusWithTime(backupHistoryElement.getStartTime(), "Backup Started"), "", WeeklyMailChangesNew.getDay(backupHistoryElement.getStartTime()), "");
                        } else {
                            WeeklyMailChangesNew.setBackupStatusForDay(tempEmail, startDayVal, WeeklyMailChangesNew.getStatusWithTime(backupHistoryElement.getStartTime(), "Backup resumed"), "", WeeklyMailChangesNew.getDay(backupHistoryElement.getStartTime()), "");
                        }
                    }
                    System.out.println(String.valueOf(backupHistoryElement.getEndTime()) + "................" + backupHistoryElement.getAction());
                    if ("User Exited the agent manually".equals(backupHistoryElement.getAction())) {
                        WeeklyMailChangesNew.setBackupStatusForDay(tempEmail, dayVal, WeeklyMailChangesNew.getStatusWithTime(backupHistoryElement.getEndTime(), "Backup Interrupted"), backupHistoryElement.getAction(), dateToCheck, WeeklyMailChangesNew.getCompletionDetails(backupHistoryElement));
                    }
                    if ("Network disconnected during backup".equals(backupHistoryElement.getAction())) {
                        WeeklyMailChangesNew.setBackupStatusForDay(tempEmail, dayVal, WeeklyMailChangesNew.getStatusWithTime(backupHistoryElement.getEndTime(), "Backup Interrupted"), backupHistoryElement.getAction(), dateToCheck, WeeklyMailChangesNew.getCompletionDetails(backupHistoryElement));
                    }
                    if ("User paused BackUp manually.".equals(backupHistoryElement.getAction())) {
                        WeeklyMailChangesNew.setBackupStatusForDay(tempEmail, dayVal, WeeklyMailChangesNew.getStatusWithTime(backupHistoryElement.getEndTime(), "Backup Interrupted"), backupHistoryElement.getAction(), dateToCheck, WeeklyMailChangesNew.getCompletionDetails(backupHistoryElement));
                    }
                    if ("Backup Deferred.".equals(backupHistoryElement.getAction())) {
                        WeeklyMailChangesNew.setBackupStatusForDay(tempEmail, dayVal, WeeklyMailChangesNew.getStatusWithTime(backupHistoryElement.getEndTime(), "Backup Interrupted"), backupHistoryElement.getAction(), dateToCheck, WeeklyMailChangesNew.getCompletionDetails(backupHistoryElement));
                    }
                    if ("User stopped BackUp manually".equals(backupHistoryElement.getAction())) {
                        WeeklyMailChangesNew.setBackupStatusForDay(tempEmail, dayVal, WeeklyMailChangesNew.getStatusWithTime(backupHistoryElement.getEndTime(), "Aborted"), backupHistoryElement.getAction(), dateToCheck, WeeklyMailChangesNew.getCompletionDetails(backupHistoryElement));
                    }
                }
                prviousState = backupHistoryElement.getAction();
            }
            ++i;
        }
        DeviceBackupOverView backupOverView = new DeviceBackupOverView();
        Device deviceObject = new Device();
        backupOverView.setEpaInstallationDate(deviceBkpOverview.getString("epaInstallationDate"));
        deviceObject.setDeviceName(device.getString("deviceName"));
        WeeklyMailChangesNew.setNoAttemptForSendmail(tempEmail, backupHistoryElements, backupOverView);
        bodyData.append(WeeklyMailChangesNew.setDynamicDeviceTemplate(deviceObject, tempEmail, backupOverView));
        System.out.println(bodyData);
        try {
            FileWriter myWriter = new FileWriter("/home/druva/Desktop/test.html");
            myWriter.write(bodyData.toString());
            myWriter.close();
            System.out.println("Successfully wrote to the file.");
        }
        catch (IOException e) {
            System.out.println("An error occurred.");
            e.printStackTrace();
        }
    }

    private static String getCommentsForBackupBatch(String errorCode) {
        String comments = "";
        if (StringUtils.isEmpty(errorCode)) {
            return "";
        }
        if ("0".equals(errorCode)) {
            comments = "Successfully Completed";
        }
        if ("909".equals(errorCode)) {
            comments = "Network disconnected during backup";
        }
        if ("911".equals(errorCode)) {
            comments = "User Exited the agent manually";
        }
        if ("912".equals(errorCode)) {
            comments = "Machine Utilization exceeded during backup";
        }
        if ("2304".equals(errorCode)) {
            comments = "Backup temporarily suspended because server is busy.Will be retried later";
        }
        if ("1992".equals(errorCode)) {
            comments = "User paused BackUp manually.";
        }
        if ("1981".equals(errorCode)) {
            comments = "User storage limit reached.";
        }
        if ("1996".equals(errorCode)) {
            comments = "Backup Deferred.";
        }
        if ("1207".equals(errorCode)) {
            comments = "User stopped BackUp manually";
        }
        if ("1208".equals(errorCode)) {
            comments = "Admin paused BackUp manually";
        }
        if ("1209".equals(errorCode)) {
            comments = "Admin stopped BackUp manually";
        }
        return comments;
    }

    private static void setBackupStatusForDay(EmailProps email, int dayValue, String status, String remark, String date, String complitionDetails) {
        if (status.contains("Backup Interrupted") || status.contains("Completed")) {
            status = String.valueOf(status) + "<hr>";
        }
        if (!StringUtils.isEmpty(complitionDetails)) {
            complitionDetails = String.valueOf(complitionDetails) + "<hr>";
        }
        String tempRemark = NILL;
        if (!StringUtils.isEmpty(remark)) {
            tempRemark = String.valueOf(remark) + "<hr>";
        }
        switch (dayValue) {
            case 1: {
                email.setSundayStatus(status);
                email.setSundayRemarks(tempRemark);
                email.setSundayDate(date);
                email.setSundayComplitionDetails(complitionDetails);
                break;
            }
            case 2: {
                email.setMondayStatus(status);
                email.setMondayRemarks(tempRemark);
                email.setMondayDate(date);
                email.setMondayComplitionDetails(complitionDetails);
                break;
            }
            case 3: {
                email.setTuesdayStatus(status);
                email.setTuesdayRemarks(tempRemark);
                email.setTuesdayDate(date);
                email.setTuesdayComplitionDetails(complitionDetails);
                break;
            }
            case 4: {
                email.setWednesdayStatus(status);
                email.setWednesDayRemarks(tempRemark);
                email.setWednesdayDate(date);
                email.setWednesdayComplitionDetails(complitionDetails);
                break;
            }
            case 5: {
                email.setThursdayStatus(status);
                email.setThursdayRemarks(tempRemark);
                email.setThursdayDate(date);
                email.setThursdayComplitionDetails(complitionDetails);
                break;
            }
            case 6: {
                email.setFridayStatus(status);
                email.setFridayRemarks(tempRemark);
                email.setFridayDate(date);
                email.setFridayComplitionDetails(complitionDetails);
                break;
            }
            case 7: {
                email.setSaturdayStatus(status);
                email.setSaturdayRemarks(tempRemark);
                email.setSaturdayDate(date);
                email.setSaturdayComplitionDetails(complitionDetails);
                break;
            }
            default: {
                System.out.println(INVALID_DAY_VALUE);
            }
        }
    }

    private static void setDaysElementForSendmail(EmailProps email) {
        email.setMonday(WeeklyMailChanges.DaysEnum.MONDAY.toString());
        email.setMondayRemark(NILL);
        email.setTuesday(WeeklyMailChanges.DaysEnum.TUESDAY.toString());
        email.setTuesdayRemark(NILL);
        email.setWednesday(WeeklyMailChanges.DaysEnum.WEDNESDAY.toString());
        email.setWednesdayRemark(NILL);
        email.setThursday(WeeklyMailChanges.DaysEnum.THURSDAY.toString());
        email.setThursdayRemark(NILL);
        email.setFriday(WeeklyMailChanges.DaysEnum.FRIDAY.toString());
        email.setFridayRemark(NILL);
        email.setSaturday(WeeklyMailChanges.DaysEnum.SATURDAY.toString());
        email.setSaturdayRemark(NILL);
        email.setSunday(WeeklyMailChanges.DaysEnum.SUNDAY.toString());
        email.setSundayRemark(NILL);
    }

    private static String getEndDate() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(11, 23);
        cal.set(12, 55);
        ((Calendar)cal).add(5, -1);
        Date date = cal.getTime();
        SimpleDateFormat formatter = new SimpleDateFormat(MM_DD_YYYY);
        return formatter.format(date);
    }

    private String getStartDate() {
        GregorianCalendar cal = new GregorianCalendar();
        ((Calendar)cal).add(5, -7);
        Date fiveDaysAgo = cal.getTime();
        SimpleDateFormat formatter = new SimpleDateFormat(MM_DD_YYYY);
        return formatter.format(fiveDaysAgo);
    }

    private static String getDateForApproprioteDay(int i) {
        GregorianCalendar cal = new GregorianCalendar();
        ((Calendar)cal).add(5, -7 + i);
        Date fiveDaysAgo = cal.getTime();
        SimpleDateFormat formatter = new SimpleDateFormat(MM_DD_YYYY);
        return formatter.format(fiveDaysAgo);
    }

    private static String getDay(String startDate) {
        String date = "";
        try {
            SimpleDateFormat df2 = new SimpleDateFormat(MM_DD_YYYY);
            Date dateD = new Date(startDate);
            date = df2.format(dateD);
        }
        catch (NumberFormatException e) {
            System.out.println(NUMBER_FORMAT_EXCEPTION + e);
            System.out.println(NUMBER_FORMAT_EXCEPTION + e.getMessage());
        }
        return date;
    }

    private static int getDayOfTheWeek(String dat) {
        SimpleDateFormat format = new SimpleDateFormat(MM_DD_YYYY);
        Date date = null;
        try {
            date = format.parse(dat);
        }
        catch (ParseException e) {
            System.out.println(PARSE_EXCEPTION + e);
            System.out.println(PARSE_EXCEPTION + e.getMessage());
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(7);
    }

    private static String getDate(long dateVal) {
        String date = "";
        try {
            SimpleDateFormat df2 = new SimpleDateFormat(MM_DD_YYYY_HH_MM_SS);
            Date dateD = new Date(dateVal);
            date = df2.format(dateD);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        return date;
    }

    private static void setDate(EmailProps email, int dayValue, String date) {
        switch (dayValue) {
            case 1: {
                email.setSundayDate(date);
                break;
            }
            case 2: {
                email.setMondayDate(date);
                break;
            }
            case 3: {
                email.setTuesdayDate(date);
                break;
            }
            case 4: {
                email.setWednesdayDate(date);
                break;
            }
            case 5: {
                email.setThursdayDate(date);
                break;
            }
            case 6: {
                email.setFridayDate(date);
                break;
            }
            case 7: {
                email.setSaturdayDate(date);
                break;
            }
            default: {
                System.out.println(INVALID_DAY_VALUE);
            }
        }
    }

    private static void setBackupStatusForPreviousDays(EmailProps email, List<Integer> batchStartDayValue, String batchId) {
        String status = "In progress";
        batchStartDayValue.stream().forEach(dayValue -> {
            switch (dayValue) {
                case 7: {
                    email.setSaturdayStatus(status);
                    break;
                }
                case 6: {
                    email.setFridayStatus(status);
                    break;
                }
                case 5: {
                    email.setThursdayStatus(status);
                    break;
                }
                case 4: {
                    email.setWednesdayStatus(status);
                    break;
                }
                case 3: {
                    email.setTuesdayStatus(status);
                    break;
                }
                case 2: {
                    email.setMondayStatus(status);
                    break;
                }
                case 1: {
                    email.setSundayStatus(status);
                    break;
                }
                default: {
                    System.out.println(INVALID_DAY_VALUE);
                }
            }
        });
    }

    private static String getWeekDay(int day) {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat simpleDateformat = new SimpleDateFormat("EEEE");
        if (day != 0) {
            cal.add(5, -day);
        }
        return simpleDateformat.format(cal.getTime());
    }

    private static String getWeekDate(int day) {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat simpleDateformat = new SimpleDateFormat("dd/MM/yyyy");
        if (day != 0) {
            cal.add(5, -day);
        }
        return simpleDateformat.format(cal.getTime());
    }

    private static List<String> getStatus(int day, EmailProps email) {
        Calendar cal = Calendar.getInstance();
        cal.add(5, -day);
        int dayValue = cal.get(7);
        switch (dayValue) {
            case 7: {
                return email.getSaturdayStatus();
            }
            case 6: {
                return email.getFridayStatus();
            }
            case 5: {
                return email.getThursdayStatus();
            }
            case 4: {
                return email.getWednesdayStatus();
            }
            case 3: {
                return email.getTuesdayStatus();
            }
            case 2: {
                return email.getMondayStatus();
            }
            case 1: {
                return email.getSundayStatus();
            }
        }
        System.out.println(INVALID_DAY_VALUE);
        return null;
    }

    private static List<String> getRemarks(int day, EmailProps email) {
        Calendar cal = Calendar.getInstance();
        cal.add(5, -day);
        int dayValue = cal.get(7);
        switch (dayValue) {
            case 7: {
                return email.getSaturdayRemarks();
            }
            case 6: {
                return email.getFridayRemarks();
            }
            case 5: {
                return email.getThursdaydRemarks();
            }
            case 4: {
                return email.getWednesdayRemarks();
            }
            case 3: {
                return email.getTuesdayRemarks();
            }
            case 2: {
                return email.getMondayRemarks();
            }
            case 1: {
                return email.getSundayRemarks();
            }
        }
        System.out.println(INVALID_DAY_VALUE);
        return null;
    }

    private static List<String> getCompletionPercentage(int day, EmailProps email) {
        Calendar cal = Calendar.getInstance();
        cal.add(5, -day);
        int dayValue = cal.get(7);
        switch (dayValue) {
            case 7: {
                return email.getSaturdayComplitionDetails();
            }
            case 6: {
                return email.getFridayComplitionDetails();
            }
            case 5: {
                return email.getThursdayComplitionDetails();
            }
            case 4: {
                return email.getWednesdayComplitionDetails();
            }
            case 3: {
                return email.getTuesdayComplitionDetails();
            }
            case 2: {
                return email.getMondayComplitionDetails();
            }
            case 1: {
                return email.getSundayComplitionDetails();
            }
        }
        System.out.println(INVALID_DAY_VALUE);
        return null;
    }

    private static List<Integer> getDaysOfBatch(String activityStartDateString, int currentDayTemp) {
        int currentDay = currentDayTemp;
        String batchStartDateString = WeeklyMailChangesNew.getDateForApproprioteDay(0);
        Date activityStartTime = null;
        Date batchStartTime = null;
        SimpleDateFormat format = new SimpleDateFormat(MM_DD_YYYY);
        try {
            activityStartTime = format.parse(activityStartDateString);
            batchStartTime = format.parse(batchStartDateString);
        }
        catch (ParseException e) {
            System.out.println(PARSE_EXCEPTION + e);
            System.out.println(PARSE_EXCEPTION + e.getMessage());
        }
        Date date = activityStartTime != null && activityStartTime.before(batchStartTime) ? batchStartTime : activityStartTime;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int startDay = calendar.get(7);
        ArrayList<Integer> days = new ArrayList<Integer>();
        if (startDay > currentDay) {
            currentDay += 7;
        }
        if (activityStartTime != null && !activityStartTime.before(batchStartTime)) {
            ++startDay;
        }
        int i = startDay;
        while (i < currentDay) {
            int day = i % 7;
            if (day == 0) {
                day = 7;
            }
            days.add(day);
            ++i;
        }
        return days;
    }

    private static String getMultipleStatusTemplate(List<String> statusList) {
        StringBuilder statusTemplate = new StringBuilder();
        if (!CollectionUtils.isEmpty(statusList)) {
            statusList.forEach(status -> statusTemplate.append((String)status).append("<br>"));
        }
        return statusTemplate.toString();
    }

    private static String getMultipleStatusTemplateRemarks(List<String> statusList) {
        StringBuilder statusTemplate = new StringBuilder();
        if (!CollectionUtils.isEmpty(statusList)) {
            statusList.forEach(status -> statusTemplate.append((String)status).append("<br>"));
        }
        return statusTemplate.toString();
    }

    private static String getCompletionPercentageString(List<String> statusList) {
        StringBuilder statusTemplate = new StringBuilder();
        if (!CollectionUtils.isEmpty(statusList)) {
            statusList.forEach(status -> statusTemplate.append((String)status).append("<br>"));
        }
        return statusTemplate.toString();
    }

    private static void setNoAttemptForSendmail(EmailProps email, List<BackupHistoryElement> backupHistoryElements, DeviceBackupOverView deviceBkpOverview) {
        if (CollectionUtils.isEmpty(email.getMondayStatus())) {
            if (WeeklyMailChangesNew.checkIsBkpRunning(backupHistoryElements)) {
                email.setMondayStatus("In progress");
            } else if (!WeeklyMailChangesNew.checkDeviceRegisterIsAfter(deviceBkpOverview, email.getMondayDate())) {
                email.setMondayStatus("N/A");
            } else {
                email.setMondayStatus(NO_ATTEMPT);
            }
        }
        if (CollectionUtils.isEmpty(email.getTuesdayStatus())) {
            if (WeeklyMailChangesNew.checkIsBkpRunning(backupHistoryElements)) {
                email.setTuesdayStatus("In progress");
            } else if (!WeeklyMailChangesNew.checkDeviceRegisterIsAfter(deviceBkpOverview, email.getTuesdayDate())) {
                email.setTuesdayStatus("N/A");
            } else {
                email.setTuesdayStatus(NO_ATTEMPT);
            }
        }
        if (CollectionUtils.isEmpty(email.getWednesdayStatus())) {
            if (WeeklyMailChangesNew.checkIsBkpRunning(backupHistoryElements)) {
                email.setWednesdayStatus("In progress");
            } else if (!WeeklyMailChangesNew.checkDeviceRegisterIsAfter(deviceBkpOverview, email.getWednesdayDate())) {
                email.setWednesdayStatus("N/A");
            } else {
                email.setWednesdayStatus(NO_ATTEMPT);
            }
        }
        if (CollectionUtils.isEmpty(email.getThursdayStatus())) {
            if (WeeklyMailChangesNew.checkIsBkpRunning(backupHistoryElements)) {
                email.setThursdayStatus("In progress");
            } else if (!WeeklyMailChangesNew.checkDeviceRegisterIsAfter(deviceBkpOverview, email.getThursdayDate())) {
                email.setThursdayStatus("N/A");
            } else {
                email.setThursdayStatus(NO_ATTEMPT);
            }
        }
        if (CollectionUtils.isEmpty(email.getFridayStatus())) {
            if (WeeklyMailChangesNew.checkIsBkpRunning(backupHistoryElements)) {
                email.setFridayStatus("In progress");
            } else if (!WeeklyMailChangesNew.checkDeviceRegisterIsAfter(deviceBkpOverview, email.getFridayDate())) {
                email.setFridayStatus("N/A");
            } else {
                email.setFridayStatus(NO_ATTEMPT);
            }
        }
        if (CollectionUtils.isEmpty(email.getSaturdayStatus())) {
            if (WeeklyMailChangesNew.checkIsBkpRunning(backupHistoryElements)) {
                email.setSaturdayStatus("In progress");
            } else if (!WeeklyMailChangesNew.checkDeviceRegisterIsAfter(deviceBkpOverview, email.getSaturdayDate())) {
                email.setSaturdayStatus("N/A");
            } else {
                email.setSaturdayStatus(NO_ATTEMPT);
            }
        }
        if (CollectionUtils.isEmpty(email.getSundayStatus())) {
            if (WeeklyMailChangesNew.checkIsBkpRunning(backupHistoryElements)) {
                email.setSundayStatus("In progress");
            } else if (!WeeklyMailChangesNew.checkDeviceRegisterIsAfter(deviceBkpOverview, email.getSundayDate())) {
                email.setSundayStatus("N/A");
            } else {
                email.setSundayStatus(NO_ATTEMPT);
            }
        }
    }

    private static boolean checkIsBkpRunning(List<BackupHistoryElement> backupHistoryElements) {
        boolean result = false;
        if (!CollectionUtils.isEmpty(backupHistoryElements) && backupHistoryElements.size() == 1 && backupHistoryElements.get(0) != null) {
            try {
                Date batchStartDate = new SimpleDateFormat(MM_DD_YYYY).parse(backupHistoryElements.get(0).getStartTime());
                Date batchEndDate = new SimpleDateFormat(MM_DD_YYYY).parse(backupHistoryElements.get(0).getStartTime());
                Calendar cal = Calendar.getInstance();
                cal.add(5, -8);
                Date mailStartDate = cal.getTime();
                boolean isBefore = mailStartDate.before(batchStartDate);
                cal = Calendar.getInstance();
                cal.add(5, -1);
                Date mailEndDate = cal.getTime();
                boolean isAfter = batchEndDate.after(mailEndDate);
                if (isAfter && isBefore) {
                    result = true;
                }
            }
            catch (ParseException e) {
                System.out.println(NUMBER_FORMAT_EXCEPTION + e);
                System.out.println(NUMBER_FORMAT_EXCEPTION + e.getMessage());
            }
        }
        return result;
    }

    private static boolean checkDeviceRegisterIsAfter(DeviceBackupOverView device, String daysDate) {
        boolean result = false;
        if (device != null && StringUtils.isNotEmpty(device.getEpaInstallationDate()) && !StringUtils.isEmpty(daysDate)) {
            try {
                Date date = new SimpleDateFormat(MM_DD_YYYY).parse(daysDate);
                SimpleDateFormat df2 = new SimpleDateFormat(MM_DD_YYYY);
                Date dateD = new Date(Long.parseLong(device.getEpaInstallationDate()));
                df2.format(dateD);
                Date dateD1 = new SimpleDateFormat(MM_DD_YYYY).parse(df2.format(dateD));
                boolean isAfter = date.after(dateD1);
                if (isAfter) {
                    result = true;
                }
            }
            catch (ParseException e) {
                System.out.println(NUMBER_FORMAT_EXCEPTION + e);
                System.out.println(NUMBER_FORMAT_EXCEPTION + e.getMessage());
            }
        }
        return result;
    }

    private static String getStatusWithTime(String time, String status) {
        String formatedTime = WeeklyMailChangesNew.getTime(time);
        return status + " - " + formatedTime;
    }

    private static String getCompletionDetails(BackupHistoryElement backupHistoryElement) {
        return "(" + backupHistoryElement.getNoOfFiles() + ")Completed";
    }

    private static String getTime(String startDate) {
        String date = "";
        try {
            SimpleDateFormat df2 = new SimpleDateFormat("HH:mm:ss");
            Date dateD = new Date(startDate);
            date = df2.format(dateD);
        }
        catch (NumberFormatException e) {
            System.out.println(NUMBER_FORMAT_EXCEPTION + e);
            System.out.println(NUMBER_FORMAT_EXCEPTION + e.getMessage());
        }
        return date;
    }

    private static boolean isBackupStartedinWindowPeriod(String activityStartDateString) {
        String batchStartDateString = WeeklyMailChangesNew.getDateForApproprioteDay(0);
        Date activityStartTime = null;
        Date batchStartTime = null;
        SimpleDateFormat format = new SimpleDateFormat(MM_DD_YYYY);
        try {
            activityStartTime = format.parse(activityStartDateString);
            batchStartTime = format.parse(batchStartDateString);
        }
        catch (ParseException e) {
            System.out.println(PARSE_EXCEPTION + e);
            System.out.println(PARSE_EXCEPTION + e.getMessage());
        }
        return activityStartTime == null || !activityStartTime.before(batchStartTime);
    }

    private static boolean isdateAfter(String batchEndDate, String windowEndDate) {
        boolean isdateBefore = false;
        try {
            SimpleDateFormat format = new SimpleDateFormat(MM_DD_YYYY);
            if (StringUtils.isNotEmpty(batchEndDate) && StringUtils.isNotEmpty(windowEndDate)) {
                Date formatedBatchEndDate = format.parse(batchEndDate);
                Date formatedWindowEndDate = format.parse(windowEndDate);
                isdateBefore = formatedBatchEndDate.after(formatedWindowEndDate);
            }
        }
        catch (Exception e) {
            System.out.println(NUMBER_FORMAT_EXCEPTION + e);
            System.out.println(NUMBER_FORMAT_EXCEPTION + e.getMessage());
        }
        return isdateBefore;
    }

    private static String setDynamicDeviceTemplate(Device device, EmailProps email, DeviceBackupOverView bkpOverview) {
        StringBuilder bodyData = new StringBuilder("<table class=\"table\" style=\"width:100%\">");
        bodyData.append("<thead>").append("<tr align=\"center\" style=\"border: 1px solid black;\">").append("<th style=\"border: 1px solid black;text-align: center\">").append("Device Name").append("</th>").append("<th colspan=\"4\" style=\"border: 1px solid black;text-align: center\">").append(device.getDeviceName()).append("</th>").append("</tr>").append("</thead>").append("<tbody>").append("<tr align=\"center\" style=\"border: 1px solid black;\">").append("<th style=\"border: 1px solid black;text-align: center\">").append("Last Successful").append("<br>").append("Backup").append("</th>").append("<th colspan=\"4\" style=\"border: 1px solid black;text-align: center\">").append(Optional.ofNullable(bkpOverview.getLastSuccessfulBkp()).orElse("")).append("</th>").append("</tr>").append("<tr align=\"center\" style=\"border: 1px solid black;\">").append("<th colspan=\"5\" style=\"border: 1px solid black;text-align: center\">").append("Day Wise Status").append("</th>").append("</tr>").append("<th style=\"border: 1px solid black;text-align: center\">").append("Day").append("</th>").append("<th style=\"border: 1px solid black;text-align: center\">").append("Date").append("</th>").append("<th style=\"border: 1px solid black;text-align: center\">").append("Backup Status").append("</th>").append("<th style=\"border: 1px solid black;text-align: center\">").append("Completion Details").append("<th style=\"border: 1px solid black;text-align: center\">").append("Details").append("</th>").append("<tr align=\"center\" style=\"border: 1px solid black;\">").append("<td style=\"border: 1px solid black;width:").append("20%;\">").append(WeeklyMailChangesNew.getWeekDay(7)).append("</td>").append("<td style=\"border: 1px solid black;width:").append(";\">").append(WeeklyMailChangesNew.getWeekDate(7)).append("</td>").append("<td style=\"border: 1px solid black;width:").append("30%;\">").append(WeeklyMailChangesNew.getMultipleStatusTemplate(WeeklyMailChangesNew.getStatus(7, email))).append("</td>").append("<td style=\"border: 1px solid black;width:").append("20%;\">").append(WeeklyMailChangesNew.getCompletionPercentageString(WeeklyMailChangesNew.getCompletionPercentage(7, email))).append("</td>").append("<td style=\"border: 1px solid black;\">").append(WeeklyMailChangesNew.getMultipleStatusTemplateRemarks(WeeklyMailChangesNew.getRemarks(7, email))).append("</td>").append("</tr>").append("<tr align=\"center\" style=\"border: 1px solid black;\">").append("<td style=\"border: 1px solid black;\">").append(WeeklyMailChangesNew.getWeekDay(6)).append("</td>").append("<td style=\"border: 1px solid black;\">").append(WeeklyMailChangesNew.getWeekDate(6)).append("</td>").append("<td style=\"border: 1px solid black;\">").append(WeeklyMailChangesNew.getMultipleStatusTemplate(WeeklyMailChangesNew.getStatus(6, email))).append("</td>").append("<td style=\"border: 1px solid black;\">").append(WeeklyMailChangesNew.getCompletionPercentageString(WeeklyMailChangesNew.getCompletionPercentage(6, email))).append("</td>").append("<td style=\"border: 1px solid black;\">").append(WeeklyMailChangesNew.getMultipleStatusTemplateRemarks(WeeklyMailChangesNew.getRemarks(6, email))).append("</td>").append("</tr>").append("<tr align=\"center\" style=\"border: 1px solid black;\">").append("<td style=\"border: 1px solid black;\">").append(WeeklyMailChangesNew.getWeekDay(5)).append("</td>").append("<td style=\"border: 1px solid black;\">").append(WeeklyMailChangesNew.getWeekDate(5)).append("</td>").append("<td style=\"border: 1px solid black;\">").append(WeeklyMailChangesNew.getMultipleStatusTemplate(WeeklyMailChangesNew.getStatus(5, email))).append("</td>").append("<td style=\"border: 1px solid black;\">").append(WeeklyMailChangesNew.getCompletionPercentageString(WeeklyMailChangesNew.getCompletionPercentage(5, email))).append("</td>").append("<td style=\"border: 1px solid black;\">").append(WeeklyMailChangesNew.getMultipleStatusTemplateRemarks(WeeklyMailChangesNew.getRemarks(5, email))).append("</td>").append("</tr>").append("<tr align=\"center\" style=\"border: 1px solid black;\">").append("<td style=\"border: 1px solid black;\">").append(WeeklyMailChangesNew.getWeekDay(4)).append("</td>").append("<td style=\"border: 1px solid black;\">").append(WeeklyMailChangesNew.getWeekDate(4)).append("</td>").append("<td style=\"border: 1px solid black;\">").append(WeeklyMailChangesNew.getMultipleStatusTemplate(WeeklyMailChangesNew.getStatus(4, email))).append("</td>").append("<td style=\"border: 1px solid black;\">").append(WeeklyMailChangesNew.getCompletionPercentageString(WeeklyMailChangesNew.getCompletionPercentage(4, email))).append("</td>").append("<td style=\"border: 1px solid black;\">").append(WeeklyMailChangesNew.getMultipleStatusTemplateRemarks(WeeklyMailChangesNew.getRemarks(4, email))).append("</td>").append("</tr>").append("<tr align=\"center\" style=\"border: 1px solid black;\">").append("<td style=\"border: 1px solid black;\">").append(WeeklyMailChangesNew.getWeekDay(3)).append("</td>").append("<td style=\"border: 1px solid black;\">").append(WeeklyMailChangesNew.getWeekDate(3)).append("</td>").append("<td style=\"border: 1px solid black;\">").append(WeeklyMailChangesNew.getMultipleStatusTemplate(WeeklyMailChangesNew.getStatus(3, email))).append("</td>").append("<td style=\"border: 1px solid black;\">").append(WeeklyMailChangesNew.getCompletionPercentageString(WeeklyMailChangesNew.getCompletionPercentage(3, email))).append("</td>").append("<td style=\"border: 1px solid black;\">").append(WeeklyMailChangesNew.getMultipleStatusTemplateRemarks(WeeklyMailChangesNew.getRemarks(3, email))).append("</td>").append("</tr>").append("<tr align=\"center\" style=\"border: 1px solid black;\">").append("<td style=\"border: 1px solid black;\">").append(WeeklyMailChangesNew.getWeekDay(2)).append("</td>").append("<td style=\"border: 1px solid black;\">").append(WeeklyMailChangesNew.getWeekDate(2)).append("</td>").append("<td style=\"border: 1px solid black;\">").append(WeeklyMailChangesNew.getMultipleStatusTemplate(WeeklyMailChangesNew.getStatus(2, email))).append("</td>").append("<td style=\"border: 1px solid black;\">").append(WeeklyMailChangesNew.getCompletionPercentageString(WeeklyMailChangesNew.getCompletionPercentage(2, email))).append("</td>").append("<td style=\"border: 1px solid black;\">").append(WeeklyMailChangesNew.getMultipleStatusTemplateRemarks(WeeklyMailChangesNew.getRemarks(2, email))).append("</td>").append("</tr>").append("<tr align=\"center\" style=\"border: 1px solid black;\">").append("<td style=\"border: 1px solid black;\">").append(WeeklyMailChangesNew.getWeekDay(1)).append("</td>").append("<td style=\"border: 1px solid black;\">").append(WeeklyMailChangesNew.getWeekDate(1)).append("</td>").append("<td style=\"border: 1px solid black;\">").append(WeeklyMailChangesNew.getMultipleStatusTemplate(WeeklyMailChangesNew.getStatus(1, email))).append("</td>").append("<td style=\"border: 1px solid black;\">").append(WeeklyMailChangesNew.getCompletionPercentageString(WeeklyMailChangesNew.getCompletionPercentage(1, email))).append("</td>").append("<td style=\"border: 1px solid black;\">").append(WeeklyMailChangesNew.getMultipleStatusTemplateRemarks(WeeklyMailChangesNew.getRemarks(1, email))).append("</td>").append("</tr>").append("</tbody>").append("</table>").append("<br>");
        return bodyData.toString();
    }
}

