/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ultradns.ws.internal;

import com.google.common.base.Function;
import java.util.EnumSet;
import javax.inject.Inject;
import org.jclouds.ultradns.ws.domain.DirectionalPool;

public class DirectionalPoolRecordTypeToString
implements Function<Object, String> {
    @Inject
    private DirectionalPoolRecordTypeToString() {
    }

    @Override
    public String apply(Object in) {
        int rrType = (Integer)Integer.class.cast(in);
        for (DirectionalPool.RecordType type : EnumSet.allOf(DirectionalPool.RecordType.class)) {
            if (type.getCode() != rrType) continue;
            switch (type) {
                case IPV4: {
                    return "A";
                }
                case IPV6: {
                    return "AAAA";
                }
            }
            return type.toString();
        }
        throw new IllegalArgumentException("unsupported rrType " + rrType + " please see " + DirectionalPool.RecordType.class.getName());
    }
}

