/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.domain.internal;

import com.google.common.collect.Iterables;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jclouds.s3.domain.ListBucketResponse;
import org.jclouds.s3.domain.ObjectMetadata;

public class ListBucketResponseImpl
extends LinkedHashSet<ObjectMetadata>
implements ListBucketResponse {
    protected final String name;
    protected final String prefix;
    protected final int maxKeys;
    protected final String delimiter;
    protected final String marker;
    protected final String nextMarker;
    protected final Set<String> commonPrefixes;
    protected final boolean truncated;

    public ListBucketResponseImpl(String name, Iterable<ObjectMetadata> contents, String prefix, String marker, String nextMarker, int maxKeys, String delimiter, boolean isTruncated, Set<String> commonPrefixes) {
        Iterables.addAll(this, contents);
        this.name = name;
        this.prefix = prefix;
        this.marker = marker;
        this.nextMarker = nextMarker;
        this.maxKeys = maxKeys;
        this.truncated = isTruncated;
        this.delimiter = delimiter;
        this.commonPrefixes = commonPrefixes;
    }

    @Override
    public Set<String> getCommonPrefixes() {
        return this.commonPrefixes;
    }

    @Override
    public String getDelimiter() {
        return this.delimiter;
    }

    @Override
    public String getMarker() {
        return this.marker;
    }

    @Override
    public String getNextMarker() {
        return this.nextMarker;
    }

    @Override
    public int getMaxKeys() {
        return this.maxKeys;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public boolean isTruncated() {
        return this.truncated;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.commonPrefixes == null ? 0 : this.commonPrefixes.hashCode());
        result = 31 * result + (this.delimiter == null ? 0 : this.delimiter.hashCode());
        result = 31 * result + (this.marker == null ? 0 : this.marker.hashCode());
        result = 31 * result + this.maxKeys;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.prefix == null ? 0 : this.prefix.hashCode());
        result = 31 * result + (this.truncated ? 1231 : 1237);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ListBucketResponseImpl other = (ListBucketResponseImpl)obj;
        if (this.commonPrefixes == null ? other.commonPrefixes != null : !this.commonPrefixes.equals(other.commonPrefixes)) {
            return false;
        }
        if (this.delimiter == null ? other.delimiter != null : !this.delimiter.equals(other.delimiter)) {
            return false;
        }
        if (this.marker == null ? other.marker != null : !this.marker.equals(other.marker)) {
            return false;
        }
        if (this.maxKeys != other.maxKeys) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.prefix == null ? other.prefix != null : !this.prefix.equals(other.prefix)) {
            return false;
        }
        return this.truncated == other.truncated;
    }
}

