/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.route53.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class ResourceRecordSet {
    protected final String name;
    protected final String type;
    protected final Optional<Integer> ttl;
    protected final List<String> values;
    protected final Optional<AliasTarget> aliasTarget;

    private ResourceRecordSet(String name, String type, Optional<Integer> ttl, List<String> values, Optional<AliasTarget> aliasTarget) {
        this.name = Preconditions.checkNotNull(name, "name");
        this.type = Preconditions.checkNotNull(type, "type of %s", name);
        this.ttl = Preconditions.checkNotNull(ttl, "ttl for %s", name);
        Preconditions.checkArgument(ttl.or(0) >= 0, "ttl of %s must be unsigned", name);
        this.values = Preconditions.checkNotNull(values, "values for %s", name);
        this.aliasTarget = Preconditions.checkNotNull(aliasTarget, "aliasTarget for %s", name);
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public Optional<Integer> getTTL() {
        return this.ttl;
    }

    public List<String> getValues() {
        return this.values;
    }

    public Optional<AliasTarget> getAliasTarget() {
        return this.aliasTarget;
    }

    public int hashCode() {
        return Objects.hashCode(this.name, this.type);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ResourceRecordSet other = (ResourceRecordSet)ResourceRecordSet.class.cast(obj);
        return Objects.equal(this.name, other.name) && Objects.equal(this.type, other.type);
    }

    public String toString() {
        return MoreObjects.toStringHelper("").omitNullValues().add("name", this.name).add("type", this.type).add("ttl", this.ttl.orNull()).add("values", this.values.isEmpty() ? null : this.values).add("aliasTarget", this.aliasTarget.orNull()).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return ResourceRecordSet.builder().from(this);
    }

    public static final class Builder {
        private String id;
        private String name;
        private String type;
        private Optional<Integer> ttl = Optional.absent();
        private ImmutableList.Builder<String> values = ImmutableList.builder();
        private String dnsName;
        private String zoneId;
        private Integer weight;
        private String region;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder ttl(int ttl) {
            this.ttl = Optional.of(ttl);
            return this;
        }

        public Builder dnsName(String dnsName) {
            this.dnsName = dnsName;
            return this;
        }

        public Builder zoneId(String zoneId) {
            this.zoneId = zoneId;
            return this;
        }

        public Builder aliasTarget(AliasTarget aliasTarget) {
            if (aliasTarget == null) {
                this.dnsName = null;
                this.zoneId = null;
            } else {
                this.dnsName = aliasTarget.dnsName;
                this.zoneId = aliasTarget.zoneId;
            }
            return this;
        }

        public Builder add(String values) {
            this.values.add((Object)values);
            return this;
        }

        public Builder values(Iterable<String> values) {
            this.values = ImmutableList.builder().addAll(values);
            return this;
        }

        public Builder addAll(Iterable<String> values) {
            this.values.addAll((Iterable)values);
            return this;
        }

        public Builder weight(int weight) {
            this.weight = weight;
            return this;
        }

        public Builder region(String region) {
            this.region = region;
            return this;
        }

        public ResourceRecordSet build() {
            Optional aliasTarget;
            Optional<Object> optional2 = aliasTarget = this.dnsName != null ? Optional.fromNullable(AliasTarget.dnsNameInZone(this.dnsName, this.zoneId)) : Optional.absent();
            if (this.weight != null) {
                return new RecordSubset.Weighted(this.id, this.name, this.type, this.weight, this.ttl, (List)((Object)this.values.build()), aliasTarget);
            }
            if (this.region != null) {
                return new RecordSubset.Latency(this.id, this.name, this.type, this.region, this.ttl, (List)((Object)this.values.build()), aliasTarget);
            }
            return new ResourceRecordSet(this.name, this.type, this.ttl, (List)((Object)this.values.build()), aliasTarget);
        }

        public Builder from(ResourceRecordSet in) {
            if (in instanceof RecordSubset) {
                this.id(((RecordSubset)RecordSubset.class.cast(in)).id);
            }
            if (in instanceof RecordSubset.Weighted) {
                this.weight(((RecordSubset.Weighted)RecordSubset.Weighted.class.cast(in)).weight);
            } else if (in instanceof RecordSubset.Latency) {
                this.region(((RecordSubset.Latency)RecordSubset.Latency.class.cast(in)).region);
            }
            return this.name(in.name).type(in.type).ttl(in.ttl.orNull()).values(in.values).aliasTarget(in.aliasTarget.orNull());
        }
    }

    public static abstract class RecordSubset
    extends ResourceRecordSet {
        private final String id;

        private RecordSubset(String id, String name, String type, Optional<Integer> ttl, List<String> values, Optional<AliasTarget> aliasTarget) {
            super(name, type, ttl, values, aliasTarget);
            this.id = Preconditions.checkNotNull(id, "id of %s", name);
        }

        public String getId() {
            return this.id;
        }

        @Override
        public int hashCode() {
            return Objects.hashCode(super.hashCode(), this.id);
        }

        @Override
        public boolean equals(Object obj) {
            if (super.equals(obj) && obj instanceof RecordSubset) {
                RecordSubset that = (RecordSubset)RecordSubset.class.cast(obj);
                return Objects.equal(this.id, that.id);
            }
            return false;
        }

        abstract MoreObjects.ToStringHelper differentiate(MoreObjects.ToStringHelper var1);

        @Override
        public String toString() {
            return this.differentiate(MoreObjects.toStringHelper("").omitNullValues().add("id", this.id).add("name", this.name).add("type", this.type)).add("ttl", this.ttl.orNull()).add("values", this.values.isEmpty() ? null : this.values).add("aliasTarget", this.aliasTarget.orNull()).toString();
        }

        public static final class Latency
        extends RecordSubset {
            private final String region;

            private Latency(String id, String name, String type, String region, Optional<Integer> ttl, List<String> values, Optional<AliasTarget> aliasTarget) {
                super(id, name, type, ttl, values, aliasTarget);
                this.region = Preconditions.checkNotNull(region, "region of %s", name);
            }

            public String getRegion() {
                return this.region;
            }

            @Override
            MoreObjects.ToStringHelper differentiate(MoreObjects.ToStringHelper in) {
                return in.add("region", this.region);
            }
        }

        public static final class Weighted
        extends RecordSubset {
            private final int weight;

            private Weighted(String id, String name, String type, int weight, Optional<Integer> ttl, List<String> values, Optional<AliasTarget> aliasTarget) {
                super(id, name, type, ttl, values, aliasTarget);
                this.weight = weight;
            }

            public int getWeight() {
                return this.weight;
            }

            @Override
            MoreObjects.ToStringHelper differentiate(MoreObjects.ToStringHelper in) {
                return in.add("weight", this.weight);
            }
        }
    }

    public static class AliasTarget {
        private final String dnsName;
        private final String zoneId;

        public static AliasTarget dnsNameInZone(String dnsName, String zoneId) {
            return new AliasTarget(dnsName, zoneId);
        }

        private AliasTarget(String dnsName, String zoneId) {
            this.dnsName = Preconditions.checkNotNull(dnsName, "dnsName");
            this.zoneId = Preconditions.checkNotNull(zoneId, "zoneId of %s", dnsName);
        }

        public String getDNSName() {
            return this.dnsName;
        }

        public String getZoneId() {
            return this.zoneId;
        }

        public int hashCode() {
            return Objects.hashCode(this.zoneId, this.dnsName);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            AliasTarget other = (AliasTarget)AliasTarget.class.cast(obj);
            return Objects.equal(this.dnsName, other.dnsName) && Objects.equal(this.zoneId, other.zoneId);
        }

        public String toString() {
            return MoreObjects.toStringHelper("").omitNullValues().add("dnsName", this.dnsName).add("zoneId", this.zoneId).toString();
        }
    }
}

