/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cloudloadbalancers.v1.domain.internal;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.ConnectionThrottle;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.HealthMonitor;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.LoadBalancer;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.SessionPersistence;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.internal.BaseNode;

public class BaseLoadBalancer<N extends BaseNode<N>, T extends BaseLoadBalancer<N, T>>
implements Comparable<BaseLoadBalancer<N, T>> {
    private static final String ENABLED = "enabled";
    private static final String PERSISTENCE_TYPE = "persistenceType";
    public static final Collection<Algorithm> WEIGHTED_ALGORITHMS = ImmutableSet.of(Algorithm.WEIGHTED_LEAST_CONNECTIONS, Algorithm.WEIGHTED_ROUND_ROBIN);
    protected String name;
    protected String protocol;
    protected Integer port;
    protected SortedSet<N> nodes = ImmutableSortedSet.of();
    protected Algorithm algorithm;
    protected Integer timeout;
    protected Boolean halfClosed;
    protected Map<String, SessionPersistence> sessionPersistence;
    protected Map<String, Boolean> connectionLogging;
    protected ConnectionThrottle connectionThrottle;
    protected HealthMonitor healthMonitor;

    protected BaseLoadBalancer() {
    }

    public BaseLoadBalancer(String name, @Nullable String protocol, @Nullable Integer port, Iterable<N> nodes, @Nullable Algorithm algorithm, @Nullable Integer timeout, @Nullable Boolean halfClosed, @Nullable Map<String, SessionPersistence> sessionPersistence, @Nullable Map<String, Boolean> connectionLogging, @Nullable ConnectionThrottle connectionThrottle, @Nullable HealthMonitor healthMonitor) {
        this.name = Preconditions.checkNotNull(name, "name");
        this.protocol = protocol;
        this.port = port;
        this.nodes = ImmutableSortedSet.copyOf(Preconditions.checkNotNull(nodes, "nodes"));
        this.algorithm = algorithm;
        this.timeout = timeout;
        this.halfClosed = halfClosed;
        this.sessionPersistence = sessionPersistence;
        this.connectionLogging = connectionLogging;
        this.connectionThrottle = connectionThrottle;
        this.healthMonitor = healthMonitor;
    }

    @Override
    public int compareTo(BaseLoadBalancer<N, T> arg0) {
        return this.name.compareTo(arg0.name);
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public String getProtocol() {
        return this.protocol;
    }

    @Nullable
    public Integer getPort() {
        return this.port;
    }

    public Set<N> getNodes() {
        return this.nodes;
    }

    @Nullable
    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    @Nullable
    public Integer getTimeout() {
        return this.timeout;
    }

    @Nullable
    public Boolean isHalfClosed() {
        return this.halfClosed;
    }

    @Nullable
    public SessionPersistence getSessionPersistenceType() {
        return this.sessionPersistence == null ? null : this.sessionPersistence.get(PERSISTENCE_TYPE);
    }

    public boolean isConnectionLogging() {
        return this.connectionLogging == null ? false : this.connectionLogging.get(ENABLED);
    }

    @Nullable
    public ConnectionThrottle getConnectionThrottle() {
        return this.connectionThrottle;
    }

    @Nullable
    public HealthMonitor getHealthMonitor() {
        return this.healthMonitor;
    }

    protected MoreObjects.ToStringHelper string() {
        return MoreObjects.toStringHelper(this).omitNullValues().add("name", this.name).add("protocol", this.protocol).add("port", this.port).add("nodes", this.nodes).add("timeout", this.timeout).add("algorithm", (Object)this.algorithm).add("timeout", this.timeout).add("sessionPersistenceType", (Object)this.getSessionPersistenceType()).add("connectionLogging", this.connectionLogging).add("connectionThrottle", this.connectionThrottle).add("healthMonitor", this.healthMonitor);
    }

    public String toString() {
        return this.string().toString();
    }

    public int hashCode() {
        return Objects.hashCode(this.name);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        LoadBalancer that = (LoadBalancer)LoadBalancer.class.cast(obj);
        return Objects.equal(this.name, that.name);
    }

    public static <N extends BaseNode<N>, T extends BaseLoadBalancer<N, T>> Builder<N, T> builder() {
        return new Builder();
    }

    public Builder<N, T> toBuilder() {
        return new Builder().from(this);
    }

    public static class Builder<N extends BaseNode<N>, T extends BaseLoadBalancer<N, T>> {
        protected String name;
        protected String protocol;
        protected Integer port;
        protected Set<N> nodes = Sets.newLinkedHashSet();
        protected Algorithm algorithm;
        protected Integer timeout;
        protected Boolean halfClosed;
        protected Map<String, SessionPersistence> sessionPersistence;
        protected Map<String, Boolean> connectionLogging;
        protected ConnectionThrottle connectionThrottle;
        protected HealthMonitor healthMonitor;

        public Builder<N, T> name(String name) {
            this.name = Preconditions.checkNotNull(name, "name");
            return this;
        }

        public Builder<N, T> protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public Builder<N, T> port(@Nullable Integer port) {
            this.port = port;
            return this;
        }

        public Builder<N, T> nodes(Iterable<N> nodes) {
            this.nodes = ImmutableSet.copyOf(Preconditions.checkNotNull(nodes, "nodes"));
            return this;
        }

        public Builder<N, T> node(N node) {
            this.nodes.add((BaseNode)((Object)Preconditions.checkNotNull(this.nodes, "nodes")));
            return this;
        }

        public Builder<N, T> algorithm(@Nullable Algorithm algorithm) {
            this.algorithm = algorithm;
            return this;
        }

        public Builder<N, T> timeout(@Nullable Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder<N, T> halfClosed(@Nullable Boolean halfClosed) {
            this.halfClosed = halfClosed;
            return this;
        }

        public Builder<N, T> sessionPersistenceType(@Nullable SessionPersistence sessionPersistenceType) {
            if (sessionPersistenceType != null) {
                this.sessionPersistence = Maps.newHashMap();
                this.sessionPersistence.put(BaseLoadBalancer.PERSISTENCE_TYPE, sessionPersistenceType);
            } else {
                this.sessionPersistence = null;
            }
            return this;
        }

        public Builder<N, T> connectionLogging(@Nullable Boolean connectionLogging) {
            if (connectionLogging != null) {
                this.connectionLogging = Maps.newHashMap();
                this.connectionLogging.put(BaseLoadBalancer.ENABLED, connectionLogging);
            } else {
                this.connectionLogging = null;
            }
            return this;
        }

        public Builder<N, T> connectionThrottle(@Nullable ConnectionThrottle connectionThrottle) {
            this.connectionThrottle = connectionThrottle;
            return this;
        }

        public Builder<N, T> healthMonitor(@Nullable HealthMonitor healthMonitor) {
            this.healthMonitor = healthMonitor;
            return this;
        }

        public BaseLoadBalancer<N, T> build() {
            return new BaseLoadBalancer(this.name, this.protocol, this.port, this.nodes, this.algorithm, this.timeout, this.halfClosed, this.sessionPersistence, this.connectionLogging, this.connectionThrottle, this.healthMonitor);
        }

        public Builder<N, T> from(T baseLB) {
            return this.name(((BaseLoadBalancer)baseLB).getName()).protocol(((BaseLoadBalancer)baseLB).getProtocol()).port(((BaseLoadBalancer)baseLB).getPort()).algorithm(((BaseLoadBalancer)baseLB).getAlgorithm()).timeout(((BaseLoadBalancer)baseLB).getTimeout()).halfClosed(((BaseLoadBalancer)baseLB).isHalfClosed()).nodes(((BaseLoadBalancer)baseLB).getNodes()).sessionPersistenceType(((BaseLoadBalancer)baseLB).getSessionPersistenceType()).connectionLogging(((BaseLoadBalancer)baseLB).isConnectionLogging()).connectionThrottle(((BaseLoadBalancer)baseLB).getConnectionThrottle()).healthMonitor(((BaseLoadBalancer)baseLB).getHealthMonitor());
        }
    }

    public static enum Algorithm {
        LEAST_CONNECTIONS,
        RANDOM,
        ROUND_ROBIN,
        WEIGHTED_LEAST_CONNECTIONS,
        WEIGHTED_ROUND_ROBIN,
        UNRECOGNIZED;


        public static Algorithm fromValue(String algorithm) {
            try {
                return Algorithm.valueOf(Preconditions.checkNotNull(algorithm, "algorithm"));
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }
}

