/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.profitbricks.http.parser.firewall;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.List;
import org.jclouds.profitbricks.domain.Firewall;
import org.jclouds.profitbricks.http.parser.firewall.BaseFirewallResponseHandler;
import org.jclouds.profitbricks.http.parser.firewall.rule.FirewallRuleListResponseHandler;
import org.xml.sax.SAXException;

public class FirewallListResponseHandler
extends BaseFirewallResponseHandler<List<Firewall>> {
    private List<Firewall> firewalls = Lists.newArrayList();

    @Inject
    FirewallListResponseHandler(FirewallRuleListResponseHandler firewallRuleListResponseHandler) {
        super(firewallRuleListResponseHandler);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.useFirewallRuleParser) {
            this.firewallRuleListResponseHandler.endElement(uri, localName, qName);
        } else {
            this.setPropertyOnEndTag(qName);
            if ("return".equals(qName) || "firewall".equals(qName)) {
                this.firewalls.add(this.builder.rules((List<Firewall.Rule>)this.firewallRuleListResponseHandler.getResult()).build());
                this.firewallRuleListResponseHandler.reset();
                this.builder = Firewall.builder();
            }
            this.clearTextBuffer();
        }
        if ("firewallRules".equals(qName)) {
            this.useFirewallRuleParser = false;
        }
    }

    @Override
    public void reset() {
        this.firewalls = Lists.newArrayList();
    }

    @Override
    public List<Firewall> getResult() {
        return this.firewalls;
    }
}

