/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.net.domain;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import org.jclouds.net.domain.IpProtocol;
import org.jclouds.util.Strings2;

@Beta
public class IpPermission
implements Comparable<IpPermission> {
    private final int fromPort;
    private final int toPort;
    private final Multimap<String, String> tenantIdGroupNamePairs;
    private final Set<String> groupIds;
    private final IpProtocol ipProtocol;
    private final Set<String> cidrBlocks;
    private final Set<String> exclusionCidrBlocks;

    public static Builder builder() {
        return new Builder();
    }

    public IpPermission(IpProtocol ipProtocol, int fromPort, int toPort, Multimap<String, String> tenantIdGroupNamePairs, Iterable<String> groupIds, Iterable<String> cidrBlocks, Iterable<String> exclusionCidrBlocks) {
        this.fromPort = fromPort;
        this.toPort = toPort;
        this.tenantIdGroupNamePairs = ImmutableMultimap.copyOf(Preconditions.checkNotNull(tenantIdGroupNamePairs, "tenantIdGroupNamePairs"));
        this.ipProtocol = Preconditions.checkNotNull(ipProtocol, "ipProtocol");
        this.groupIds = ImmutableSet.copyOf(Preconditions.checkNotNull(groupIds, "groupIds"));
        this.cidrBlocks = ImmutableSet.copyOf(Preconditions.checkNotNull(cidrBlocks, "cidrBlocks"));
        this.exclusionCidrBlocks = ImmutableSet.copyOf(Preconditions.checkNotNull(exclusionCidrBlocks, "exclusionCidrBlocks"));
    }

    public IpProtocol getIpProtocol() {
        return this.ipProtocol;
    }

    public int getFromPort() {
        return this.fromPort;
    }

    public int getToPort() {
        return this.toPort;
    }

    public Multimap<String, String> getTenantIdGroupNamePairs() {
        return this.tenantIdGroupNamePairs;
    }

    public Set<String> getGroupIds() {
        return this.groupIds;
    }

    public Set<String> getCidrBlocks() {
        return this.cidrBlocks;
    }

    @Beta
    public Set<String> getExclusionCidrBlocks() {
        return this.exclusionCidrBlocks;
    }

    @Override
    public int compareTo(IpPermission that) {
        if (this == that) {
            return 0;
        }
        int proto = this.getIpProtocol().compareTo(that.getIpProtocol());
        if (proto != 0) {
            return proto;
        }
        int fromP = Integer.valueOf(this.fromPort).compareTo(that.fromPort);
        if (fromP != 0) {
            return fromP;
        }
        int toP = Integer.valueOf(this.toPort).compareTo(that.toPort);
        if (toP != 0) {
            return toP;
        }
        int tenantGroups = new LinkedMultiMapComparator<String, String>().compare(this.tenantIdGroupNamePairs, that.tenantIdGroupNamePairs);
        if (tenantGroups != 0) {
            return tenantGroups;
        }
        int groupIdComp = new CollectionComparator<String>().compare(this.groupIds, that.groupIds);
        if (groupIdComp != 0) {
            return groupIdComp;
        }
        int cidrComp = new CollectionComparator<String>().compare(this.cidrBlocks, that.cidrBlocks);
        if (cidrComp != 0) {
            return cidrComp;
        }
        int exclusionsComp = new CollectionComparator<String>().compare(this.exclusionCidrBlocks, that.exclusionCidrBlocks);
        if (exclusionsComp != 0) {
            return exclusionsComp;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof IpPermission)) {
            return false;
        }
        IpPermission that = (IpPermission)IpPermission.class.cast(o);
        return Objects.equal((Object)this.ipProtocol, (Object)that.ipProtocol) && Objects.equal(this.fromPort, that.fromPort) && Objects.equal(this.toPort, that.toPort) && Objects.equal(this.tenantIdGroupNamePairs, that.tenantIdGroupNamePairs) && Objects.equal(this.groupIds, that.groupIds) && Objects.equal(this.cidrBlocks, that.cidrBlocks) && Objects.equal(this.exclusionCidrBlocks, that.exclusionCidrBlocks);
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.ipProtocol, this.fromPort, this.toPort, this.tenantIdGroupNamePairs, this.groupIds, this.cidrBlocks, this.exclusionCidrBlocks});
    }

    public String toString() {
        return this.string().toString();
    }

    protected MoreObjects.ToStringHelper string() {
        return MoreObjects.toStringHelper("").add("ipProtocol", (Object)this.ipProtocol).add("fromPort", this.fromPort).add("toPort", this.toPort).add("tenantIdGroupNamePairs", this.tenantIdGroupNamePairs).add("groupIds", this.groupIds).add("cidrBlocks", this.cidrBlocks).add("exclusionCidrBlocks", this.exclusionCidrBlocks);
    }

    private static class CollectionComparator<T extends Comparable>
    implements Comparator<Collection<T>> {
        private CollectionComparator() {
        }

        @Override
        public int compare(Collection<T> o1, Collection<T> o2) {
            Iterator<T> leftIter = o1.iterator();
            Iterator<T> rightIter = o2.iterator();
            while (leftIter.hasNext() && rightIter.hasNext()) {
                int comp = ((Comparable)leftIter.next()).compareTo(rightIter.next());
                if (comp == 0) continue;
                return comp;
            }
            if (!leftIter.hasNext() && rightIter.hasNext()) {
                return -1;
            }
            if (leftIter.hasNext() && !rightIter.hasNext()) {
                return 1;
            }
            return 0;
        }
    }

    private static class LinkedMultiMapComparator<K extends Comparable, V>
    implements Comparator<Multimap<K, V>> {
        private LinkedMultiMapComparator() {
        }

        @Override
        public int compare(Multimap<K, V> map1, Multimap<K, V> map2) {
            Iterator<K> leftIter = map1.keySet().iterator();
            Iterator<K> rightIter = map2.keySet().iterator();
            while (leftIter.hasNext() && rightIter.hasNext()) {
                Comparable key2;
                Comparable key1 = (Comparable)leftIter.next();
                int keyComp = key1.compareTo(key2 = (Comparable)rightIter.next());
                if (keyComp != 0) {
                    return keyComp;
                }
                int valuesComp = new CollectionComparator<V>().compare(map1.get(key1), map2.get(key2));
                if (valuesComp == 0) continue;
                return valuesComp;
            }
            if (!leftIter.hasNext() && rightIter.hasNext()) {
                return -1;
            }
            if (leftIter.hasNext() && !rightIter.hasNext()) {
                return 1;
            }
            return 0;
        }
    }

    public static class Builder {
        private IpProtocol ipProtocol;
        private int fromPort;
        private int toPort;
        private Multimap<String, String> tenantIdGroupNamePairs = LinkedHashMultimap.create();
        private Set<String> groupIds = Sets.newLinkedHashSet();
        private Set<String> cidrBlocks = Sets.newLinkedHashSet();
        private Set<String> exclusionCidrBlocks = Sets.newLinkedHashSet();

        public Builder fromPermission(IpPermission permission) {
            this.ipProtocol = permission.ipProtocol;
            this.fromPort = permission.fromPort;
            this.toPort = permission.toPort;
            this.tenantIdGroupNamePairs = LinkedHashMultimap.create();
            this.tenantIdGroupNamePairs.putAll(permission.tenantIdGroupNamePairs);
            this.groupIds = Sets.newLinkedHashSet();
            this.groupIds.addAll(permission.groupIds);
            this.cidrBlocks = Sets.newLinkedHashSet();
            this.cidrBlocks.addAll(permission.cidrBlocks);
            this.exclusionCidrBlocks = Sets.newLinkedHashSet();
            this.exclusionCidrBlocks.addAll(permission.exclusionCidrBlocks);
            return this;
        }

        public Builder ipProtocol(IpProtocol ipProtocol) {
            this.ipProtocol = ipProtocol;
            return this;
        }

        public Builder fromPort(int fromPort) {
            this.fromPort = fromPort;
            return this;
        }

        public Builder toPort(int toPort) {
            this.toPort = toPort;
            return this;
        }

        public Builder tenantIdGroupNamePair(String tenantId, String groupName) {
            this.tenantIdGroupNamePairs.put(tenantId, groupName);
            return this;
        }

        public Builder tenantIdGroupNamePairs(Multimap<String, String> tenantIdGroupNamePairs) {
            this.tenantIdGroupNamePairs.putAll(tenantIdGroupNamePairs);
            return this;
        }

        public Builder cidrBlock(String cidrBlock) {
            Preconditions.checkArgument(Strings2.isCidrFormat(cidrBlock), "cidrBlock %s is not a valid CIDR", cidrBlock);
            this.cidrBlocks.add(cidrBlock);
            return this;
        }

        public Builder cidrBlocks(Iterable<String> cidrBlocks) {
            Iterables.addAll(this.cidrBlocks, Iterables.transform(cidrBlocks, new Function<String, String>(){

                @Override
                public String apply(String input) {
                    Preconditions.checkArgument(Strings2.isCidrFormat(input), "input %s is not a valid CIDR", input);
                    return input;
                }
            }));
            return this;
        }

        @Beta
        public Builder exclusionCidrBlock(String exclusionCidrBlock) {
            Preconditions.checkArgument(Strings2.isCidrFormat(exclusionCidrBlock), "exclusionCidrBlock %s is not a valid CIDR", exclusionCidrBlock);
            this.exclusionCidrBlocks.add(exclusionCidrBlock);
            return this;
        }

        @Beta
        public Builder exclusionCidrBlocks(Iterable<String> exclusionCidrBlocks) {
            Iterables.addAll(this.exclusionCidrBlocks, Iterables.transform(exclusionCidrBlocks, new Function<String, String>(){

                @Override
                public String apply(String input) {
                    Preconditions.checkArgument(Strings2.isCidrFormat(input), "input %s is not a valid CIDR", input);
                    return input;
                }
            }));
            return this;
        }

        public Builder groupId(String groupId) {
            this.groupIds.add(groupId);
            return this;
        }

        public Builder groupIds(Iterable<String> groupIds) {
            Iterables.addAll(this.groupIds, groupIds);
            return this;
        }

        public IpPermission build() {
            return new IpPermission(this.ipProtocol, this.fromPort, this.toPort, this.tenantIdGroupNamePairs, this.groupIds, this.cidrBlocks, this.exclusionCidrBlocks);
        }
    }
}

