/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.http.okhttp;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMultimap;
import com.google.inject.Inject;
import com.squareup.okhttp.Headers;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import java.io.IOException;
import java.net.Proxy;
import java.net.URI;
import java.util.Map;
import javax.inject.Named;
import okio.BufferedSink;
import okio.Okio;
import okio.Source;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpUtils;
import org.jclouds.http.IOExceptionRetryHandler;
import org.jclouds.http.handlers.DelegatingErrorHandler;
import org.jclouds.http.handlers.DelegatingRetryHandler;
import org.jclouds.http.internal.BaseHttpCommandExecutorService;
import org.jclouds.http.internal.HttpWire;
import org.jclouds.io.ContentMetadataCodec;
import org.jclouds.io.MutableContentMetadata;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.jclouds.io.payloads.InputStreamPayload;
import org.jclouds.logging.Logger;

public final class OkHttpCommandExecutorService
extends BaseHttpCommandExecutorService<Request> {
    private final Function<URI, Proxy> proxyForURI;
    private final OkHttpClient globalClient;
    private final String userAgent;

    @Inject
    OkHttpCommandExecutorService(HttpUtils utils, ContentMetadataCodec contentMetadataCodec, DelegatingRetryHandler retryHandler, IOExceptionRetryHandler ioRetryHandler, DelegatingErrorHandler errorHandler, HttpWire wire, Function<URI, Proxy> proxyForURI, OkHttpClient okHttpClient, @Named(value="jclouds.idempotent-methods") String idempotentMethods, @Named(value="jclouds.user-agent") String userAgent) {
        super(utils, contentMetadataCodec, retryHandler, ioRetryHandler, errorHandler, wire, idempotentMethods);
        this.proxyForURI = proxyForURI;
        this.globalClient = okHttpClient;
        this.userAgent = userAgent;
    }

    @Override
    protected Request convert(HttpRequest request) throws IOException, InterruptedException {
        Long length;
        Request.Builder builder = new Request.Builder();
        builder.url(request.getEndpoint().toString());
        this.populateHeaders(request, builder);
        RequestBody body = null;
        Payload payload = request.getPayload();
        if (payload != null && (length = Preconditions.checkNotNull(payload.getContentMetadata().getContentLength(), "payload.getContentLength")) > 0L) {
            body = this.generateRequestBody(request, payload);
        }
        builder.method(request.getMethod(), body);
        return builder.build();
    }

    protected void populateHeaders(HttpRequest request, Request.Builder builder) {
        if (request.getFirstHeaderOrNull("Accept") == null) {
            builder.addHeader("Accept", "*/*");
        }
        if (request.getFirstHeaderOrNull("User-Agent") == null) {
            builder.addHeader("User-Agent", this.userAgent);
        }
        for (Map.Entry<String, String> entry : request.getHeaders().entries()) {
            builder.addHeader(entry.getKey(), entry.getValue());
        }
        if (request.getPayload() != null) {
            MutableContentMetadata md = request.getPayload().getContentMetadata();
            for (Map.Entry<String, String> entry : this.contentMetadataCodec.toHeaders(md).entries()) {
                builder.addHeader(entry.getKey(), entry.getValue());
            }
        }
    }

    protected RequestBody generateRequestBody(final HttpRequest request, final Payload payload) {
        Preconditions.checkNotNull(payload.getContentMetadata().getContentType(), "payload.getContentType");
        return new RequestBody(){

            @Override
            public void writeTo(BufferedSink sink) throws IOException {
                try (Source source = Okio.source(payload.openStream());){
                    sink.writeAll(source);
                }
            }

            @Override
            public long contentLength() throws IOException {
                return payload.getContentMetadata().getContentLength();
            }

            @Override
            public MediaType contentType() {
                return MediaType.parse(payload.getContentMetadata().getContentType());
            }
        };
    }

    @Override
    protected HttpResponse invoke(Request nativeRequest) throws IOException, InterruptedException {
        OkHttpClient requestScopedClient = this.globalClient.clone();
        requestScopedClient.setProxy(this.proxyForURI.apply(nativeRequest.uri()));
        Response response = requestScopedClient.newCall(nativeRequest).execute();
        HttpResponse.Builder<?> builder = HttpResponse.builder();
        builder.statusCode(response.code());
        builder.message(response.message());
        ImmutableMultimap.Builder<String, String> headerBuilder = ImmutableMultimap.builder();
        Headers responseHeaders = response.headers();
        for (String header : responseHeaders.names()) {
            headerBuilder.putAll(header, (Iterable<String>)responseHeaders.values(header));
        }
        ImmutableMultimap<String, String> headers = headerBuilder.build();
        if (response.code() == 204 && response.body() != null) {
            response.body().close();
        } else {
            InputStreamPayload payload = Payloads.newInputStreamPayload(response.body().byteStream());
            this.contentMetadataCodec.fromHeaders(payload.getContentMetadata(), headers);
            builder.payload(payload);
        }
        builder.headers(HttpUtils.filterOutContentHeaders(headers));
        return builder.build();
    }

    @Override
    protected void cleanup(Request nativeResponse) {
    }

    static /* synthetic */ Logger access$000(OkHttpCommandExecutorService x0) {
        return x0.logger;
    }
}

