/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.dynect.v3.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import javax.inject.Named;

public final class Job {
    @Named(value="job_id")
    private final long id;
    private final Status status;

    @ConstructorProperties(value={"job_id", "status"})
    private Job(long id, Status status) {
        this.id = id;
        this.status = Preconditions.checkNotNull(status, "status for %s", id);
    }

    public long getId() {
        return this.id;
    }

    public Status getStatus() {
        return this.status;
    }

    public int hashCode() {
        return Objects.hashCode(this.id);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Job that = (Job)Job.class.cast(obj);
        return Objects.equal(this.id, that.id);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("id", this.id).add("status", (Object)this.status).toString();
    }

    public static Job success(long id) {
        return new Job(id, Status.SUCCESS);
    }

    public static Job failure(long id) {
        return new Job(id, Status.FAILURE);
    }

    public static enum Status {
        SUCCESS,
        FAILURE,
        UNRECOGNIZED;


        public static Status fromValue(String status) {
            try {
                return Status.valueOf(Preconditions.checkNotNull(status, "status").toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }
}

