/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean2.domain;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.List;
import org.jclouds.compute.domain.OsFamily;

public enum Distribution {
    ARCHLINUX(OsFamily.ARCH, "Arch Linux"),
    CENTOS(OsFamily.CENTOS, "CentOS"),
    DEBIAN(OsFamily.DEBIAN, "Debian"),
    FEDORA(OsFamily.FEDORA, "Fedora"),
    UBUNTU(OsFamily.UBUNTU, "Ubuntu"),
    UNRECOGNIZED(OsFamily.UNRECOGNIZED, "");

    private static final List<Distribution> values;
    private final OsFamily osFamily;
    private final String value;

    private Distribution(OsFamily osFamily, String value) {
        this.osFamily = Preconditions.checkNotNull(osFamily, "osFamily cannot be null");
        this.value = Preconditions.checkNotNull(value, "value cannot be null");
    }

    public OsFamily osFamily() {
        return this.osFamily;
    }

    public String value() {
        return this.value;
    }

    public static Distribution fromValue(String value) {
        return Iterables.tryFind(values, Distribution.hasValue(value)).or(UNRECOGNIZED);
    }

    private static Predicate<Distribution> hasValue(final String value) {
        return new Predicate<Distribution>(){

            @Override
            public boolean apply(Distribution input) {
                return input.value.equalsIgnoreCase(value);
            }
        };
    }

    static {
        values = Arrays.asList(Distribution.values());
    }
}

