/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.functions;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import javax.inject.Singleton;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.functions.NodeAndTemplateOptionsToStatement;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.scriptbuilder.InitScript;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.domain.StatementList;
import org.jclouds.scriptbuilder.statements.ssh.AuthorizeRSAPublicKeys;
import org.jclouds.scriptbuilder.statements.ssh.InstallRSAPrivateKey;

@Singleton
public class InstallKeysAndRunScript
implements NodeAndTemplateOptionsToStatement {
    @Override
    public Statement apply(NodeMetadata node, TemplateOptions options) {
        String user = options.getLoginUser();
        if (user == null && node.getCredentials() != null) {
            user = node.getCredentials().getUser();
        }
        ArrayList<Statement> bootstrap = Lists.newArrayList();
        if (options.getPublicKey() != null) {
            bootstrap.add(new AuthorizeRSAPublicKeys(ImmutableSet.of(options.getPublicKey()), user));
        }
        if (options.getRunScript() != null) {
            bootstrap.add(options.getRunScript());
        }
        if (options.getPrivateKey() != null) {
            bootstrap.add(new InstallRSAPrivateKey(options.getPrivateKey()));
        }
        if (bootstrap.size() >= 1) {
            if (options.getTaskName() == null && !(options.getRunScript() instanceof InitScript)) {
                options.nameTask("bootstrap");
            }
            return bootstrap.size() == 1 ? (Statement)bootstrap.get(0) : new StatementList(bootstrap);
        }
        return null;
    }
}

